/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.datagen.v1.provider;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.data.DataOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.DataWriter;
import net.minecraft.util.Identifier;

public abstract class FabricCodecDataProvider<T>
implements DataProvider {
    private final DataOutput.PathResolver pathResolver;
    private final Codec<T> codec;

    protected FabricCodecDataProvider(FabricDataOutput dataOutput, DataOutput.OutputType outputType, String directoryName, Codec<T> codec) {
        this.pathResolver = dataOutput.getResolver(outputType, directoryName);
        this.codec = codec;
    }

    public CompletableFuture<?> run(DataWriter writer) {
        HashMap<Identifier, JsonElement> entries = new HashMap<Identifier, JsonElement>();
        BiConsumer<Identifier, Object> provider = (id, value) -> {
            JsonElement json = this.convert((Identifier)id, (T)value);
            JsonElement existingJson = entries.put((Identifier)id, json);
            if (existingJson != null) {
                throw new IllegalArgumentException("Duplicate entry " + String.valueOf(id));
            }
        };
        this.configure(provider);
        return this.write(writer, entries);
    }

    protected abstract void configure(BiConsumer<Identifier, T> var1);

    private JsonElement convert(Identifier id, T value) {
        DataResult dataResult = this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, value);
        return (JsonElement)dataResult.get().mapRight(partial -> "Invalid entry %s: %s".formatted(id, partial.message())).orThrow();
    }

    private CompletableFuture<?> write(DataWriter writer, Map<Identifier, JsonElement> entries) {
        return CompletableFuture.allOf((CompletableFuture[])entries.entrySet().stream().map(entry -> {
            Path path = this.pathResolver.resolveJson((Identifier)entry.getKey());
            return DataProvider.writeToPath((DataWriter)writer, (JsonElement)((JsonElement)entry.getValue()), (Path)path);
        }).toArray(CompletableFuture[]::new));
    }
}

