/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.datagen.v1;

import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.SharedConstants;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.registry.RegistryWrapper;
import net.minecraft.util.Identifier;
import org.jetbrains.annotations.ApiStatus;

public final class FabricDataGenerator
extends DataGenerator {
    private final ModContainer modContainer;
    private final boolean strictValidation;
    private final FabricDataOutput fabricOutput;
    private final CompletableFuture<RegistryWrapper.WrapperLookup> registriesFuture;

    @ApiStatus.Internal
    public FabricDataGenerator(Path output, ModContainer mod, boolean strictValidation, CompletableFuture<RegistryWrapper.WrapperLookup> registriesFuture) {
        super(output, SharedConstants.getGameVersion(), true);
        this.modContainer = Objects.requireNonNull(mod);
        this.strictValidation = strictValidation;
        this.fabricOutput = new FabricDataOutput(mod, output, strictValidation);
        this.registriesFuture = registriesFuture;
    }

    public Pack createPack() {
        return new Pack(true, this.modContainer.getMetadata().getName(), this.fabricOutput);
    }

    public Pack createBuiltinResourcePack(Identifier id) {
        Path path = this.output.getPath().resolve("resourcepacks").resolve(id.getPath());
        return new Pack(true, id.toString(), new FabricDataOutput(this.modContainer, path, this.strictValidation));
    }

    public ModContainer getModContainer() {
        return this.modContainer;
    }

    public String getModId() {
        return this.getModContainer().getMetadata().getId();
    }

    public boolean isStrictValidationEnabled() {
        return this.strictValidation;
    }

    @Deprecated
    public DataGenerator.Pack createVanillaPack(boolean shouldRun) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public DataGenerator.Pack createVanillaSubPack(boolean shouldRun, String packName) {
        throw new UnsupportedOperationException();
    }

    public final class Pack
    extends DataGenerator.Pack {
        private Pack(boolean shouldRun, String name, FabricDataOutput output) {
            super((DataGenerator)FabricDataGenerator.this, shouldRun, name, (DataOutput)output);
        }

        public <T extends DataProvider> T addProvider(Factory<T> factory) {
            return (T)super.addProvider(output -> factory.create((FabricDataOutput)output));
        }

        public <T extends DataProvider> T addProvider(RegistryDependentFactory<T> factory) {
            return (T)super.addProvider(output -> factory.create((FabricDataOutput)output, FabricDataGenerator.this.registriesFuture));
        }

        @FunctionalInterface
        public static interface Factory<T extends DataProvider> {
            public T create(FabricDataOutput var1);
        }

        @FunctionalInterface
        public static interface RegistryDependentFactory<T extends DataProvider> {
            public T create(FabricDataOutput var1, CompletableFuture<RegistryWrapper.WrapperLookup> var2);
        }
    }
}

