/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoCalculator;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoLuminanceFix;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractBlockRenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderInfo;
import net.minecraft.block.BlockState;
import net.minecraft.client.render.RenderLayer;
import net.minecraft.client.render.VertexConsumer;
import net.minecraft.client.render.model.BakedModel;
import net.minecraft.client.util.math.MatrixStack;
import net.minecraft.util.crash.CrashException;
import net.minecraft.util.crash.CrashReport;
import net.minecraft.util.crash.CrashReportSection;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.random.Random;
import net.minecraft.world.BlockRenderView;
import net.minecraft.world.BlockView;
import net.minecraft.world.HeightLimitView;

@Environment(value=EnvType.CLIENT)
public class BlockRenderContext
extends AbstractBlockRenderContext {
    private VertexConsumer vertexConsumer;

    @Override
    protected AoCalculator createAoCalc(BlockRenderInfo blockInfo) {
        return new AoCalculator(blockInfo){

            @Override
            public int light(BlockPos pos, BlockState state) {
                return AoCalculator.getLightmapCoordinates(this.blockInfo.blockView, state, pos);
            }

            @Override
            public float ao(BlockPos pos, BlockState state) {
                return AoLuminanceFix.INSTANCE.apply((BlockView)this.blockInfo.blockView, pos, state);
            }
        };
    }

    @Override
    protected VertexConsumer getVertexConsumer(RenderLayer layer) {
        return this.vertexConsumer;
    }

    public void render(BlockRenderView blockView, BakedModel model, BlockState state, BlockPos pos, MatrixStack matrixStack, VertexConsumer buffer, boolean cull, Random random, long seed, int overlay) {
        try {
            Vec3d offset = state.getModelOffset((BlockView)blockView, pos);
            matrixStack.translate(offset.x, offset.y, offset.z);
            this.vertexConsumer = buffer;
            this.matrix = matrixStack.peek().getPositionMatrix();
            this.normalMatrix = matrixStack.peek().getNormalMatrix();
            this.overlay = overlay;
            this.blockInfo.random = random;
            this.blockInfo.seed = seed;
            this.blockInfo.recomputeSeed = false;
            this.aoCalc.clear();
            this.blockInfo.prepareForWorld(blockView, cull);
            this.blockInfo.prepareForBlock(state, pos, model.useAmbientOcclusion());
            model.emitBlockQuads(blockView, state, pos, this.blockInfo.randomSupplier, (RenderContext)this);
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.create((Throwable)throwable, (String)"Tessellating block model - Indigo Renderer");
            CrashReportSection crashReportSection = crashReport.addElement("Block model being tessellated");
            CrashReportSection.addBlockInfo((CrashReportSection)crashReportSection, (HeightLimitView)blockView, (BlockPos)pos, (BlockState)state);
            throw new CrashException(crashReport);
        }
        finally {
            this.blockInfo.release();
            this.blockInfo.random = null;
            this.vertexConsumer = null;
        }
    }
}

