/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.object.builder.v1.entity;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.object.builder.v1.entity.MinecartComparatorLogic;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.vehicle.AbstractMinecartEntity;
import net.minecraft.registry.Registries;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MinecartComparatorLogicRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinecartComparatorLogicRegistry.class);
    private static final Map<EntityType<?>, MinecartComparatorLogic<?>> LOGICS = new IdentityHashMap();

    private MinecartComparatorLogicRegistry() {
    }

    @Nullable
    public static MinecartComparatorLogic<AbstractMinecartEntity> getCustomComparatorLogic(EntityType<?> type) {
        return LOGICS.get(type);
    }

    public static <T extends AbstractMinecartEntity> void register(EntityType<T> type, MinecartComparatorLogic<? super T> logic) {
        Objects.requireNonNull(type, "Entity type cannot be null");
        Objects.requireNonNull(logic, "Logic cannot be null");
        if (LOGICS.put(type, logic) != null) {
            LOGGER.warn("Overriding existing minecart comparator logic for entity type {}", (Object)Registries.ENTITY_TYPE.getId(type));
        }
    }
}

