/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource.loader;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.resource.ModResourcePack;
import net.fabricmc.fabric.impl.resource.loader.FabricModResourcePack;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackUtil;
import net.fabricmc.fabric.impl.resource.loader.ResourceManagerHelperImpl;
import net.minecraft.resource.ResourcePackProfile;
import net.minecraft.resource.ResourcePackProvider;
import net.minecraft.resource.ResourcePackSource;
import net.minecraft.resource.ResourceType;
import net.minecraft.text.MutableText;
import net.minecraft.text.Text;

public class ModResourcePackCreator
implements ResourcePackProvider {
    public static final ResourcePackSource RESOURCE_PACK_SOURCE = new ResourcePackSource(){

        public Text decorate(Text packName) {
            return Text.translatable((String)"pack.nameAndSource", (Object[])new Object[]{packName, Text.translatable((String)"pack.source.fabricmod")});
        }

        public boolean canBeEnabledLater() {
            return true;
        }
    };
    public static final ModResourcePackCreator CLIENT_RESOURCE_PACK_PROVIDER = new ModResourcePackCreator(ResourceType.CLIENT_RESOURCES);
    private final ResourceType type;

    public ModResourcePackCreator(ResourceType type) {
        this.type = type;
    }

    public void register(Consumer<ResourcePackProfile> consumer) {
        MutableText title;
        ResourcePackProfile resourcePackProfile;
        ArrayList<ModResourcePack> packs = new ArrayList<ModResourcePack>();
        ModResourcePackUtil.appendModResourcePacks(packs, this.type, null);
        if (!packs.isEmpty() && (resourcePackProfile = ResourcePackProfile.create((String)"fabric", (Text)(title = Text.translatable((String)"pack.name.fabricMods")), (boolean)true, factory -> new FabricModResourcePack(this.type, (List<ModResourcePack>)packs), (ResourceType)this.type, (ResourcePackProfile.InsertionPosition)ResourcePackProfile.InsertionPosition.TOP, (ResourcePackSource)RESOURCE_PACK_SOURCE)) != null) {
            consumer.accept(resourcePackProfile);
        }
        ResourceManagerHelperImpl.registerBuiltinResourcePacks(this.type, consumer);
    }
}

