/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.client.rendering;

import java.util.Locale;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.ArmorRenderer;
import net.fabricmc.fabric.impl.client.rendering.ArmorRendererRegistryImpl;
import net.minecraft.client.render.VertexConsumerProvider;
import net.minecraft.client.render.entity.feature.ArmorFeatureRenderer;
import net.minecraft.client.render.entity.feature.FeatureRenderer;
import net.minecraft.client.render.entity.feature.FeatureRendererContext;
import net.minecraft.client.render.entity.model.BipedEntityModel;
import net.minecraft.client.util.math.MatrixStack;
import net.minecraft.entity.EquipmentSlot;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Identifier;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={ArmorFeatureRenderer.class})
public abstract class ArmorFeatureRendererMixin
extends FeatureRenderer<LivingEntity, BipedEntityModel<LivingEntity>> {
    @Shadow
    @Final
    private static Map<String, Identifier> field_4829;

    private ArmorFeatureRendererMixin(FeatureRendererContext<LivingEntity, BipedEntityModel<LivingEntity>> context) {
        super(context);
    }

    @Inject(method={"renderArmor"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderArmor(MatrixStack matrices, VertexConsumerProvider vertexConsumers, LivingEntity entity, EquipmentSlot armorSlot, int light, BipedEntityModel<LivingEntity> model, CallbackInfo ci) {
        ItemStack stack = entity.getEquippedStack(armorSlot);
        ArmorRenderer renderer = ArmorRendererRegistryImpl.get(stack.getItem());
        if (renderer != null) {
            renderer.render(matrices, vertexConsumers, stack, entity, armorSlot, light, (BipedEntityModel<LivingEntity>)((BipedEntityModel)this.getContextModel()));
            ci.cancel();
        }
    }

    @Inject(method={"getArmorTexture"}, at={@At(value="HEAD")}, cancellable=true)
    private void getArmorTexture(ArmorItem item, boolean secondLayer, String overlay, CallbackInfoReturnable<Identifier> cir) {
        String name = item.getMaterial().getName();
        int separator = name.indexOf(58);
        if (separator != -1) {
            String namespace = name.substring(0, separator);
            String path = name.substring(separator + 1);
            String texture = String.format(Locale.ROOT, "%s:textures/models/armor/%s_layer_%d%s.png", namespace, path, secondLayer ? 2 : 1, overlay == null ? "" : "_" + overlay);
            cir.setReturnValue((Object)field_4829.computeIfAbsent(texture, Identifier::new));
        }
    }
}

