/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.transfer;

import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.minecraft.block.BlockState;
import net.minecraft.block.HopperBlock;
import net.minecraft.block.entity.Hopper;
import net.minecraft.block.entity.HopperBlockEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.state.property.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Direction;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={HopperBlockEntity.class})
public class HopperBlockEntityMixin {
    @Inject(at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/block/entity/HopperBlockEntity;getOutputInventory(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;)Lnet/minecraft/inventory/Inventory;")}, method={"insert(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/inventory/Inventory;)Z"}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private static void hookInsert(World world, BlockPos pos, BlockState state, Inventory inventory, CallbackInfoReturnable<Boolean> cir, Inventory targetInventory) {
        if (targetInventory != null) {
            return;
        }
        Direction direction = (Direction)state.get((Property)HopperBlock.FACING);
        BlockPos targetPos = pos.offset(direction);
        Storage target = (Storage)ItemStorage.SIDED.find(world, targetPos, (Object)direction.getOpposite());
        if (target != null) {
            long moved = StorageUtil.move(InventoryStorage.of(inventory, direction), target, iv -> true, 1L, null);
            cir.setReturnValue((Object)(moved == 1L ? 1 : 0));
        }
    }

    @Inject(at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/block/entity/HopperBlockEntity;getInputInventory(Lnet/minecraft/world/World;Lnet/minecraft/block/entity/Hopper;)Lnet/minecraft/inventory/Inventory;")}, method={"extract(Lnet/minecraft/world/World;Lnet/minecraft/block/entity/Hopper;)Z"}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private static void hookExtract(World world, Hopper hopper, CallbackInfoReturnable<Boolean> cir, Inventory inputInventory) {
        if (inputInventory != null) {
            return;
        }
        BlockPos sourcePos = BlockPos.ofFloored((double)hopper.getHopperX(), (double)(hopper.getHopperY() + 1.0), (double)hopper.getHopperZ());
        Storage source = (Storage)ItemStorage.SIDED.find(world, sourcePos, (Object)Direction.DOWN);
        if (source != null) {
            long moved = StorageUtil.move(source, InventoryStorage.of((Inventory)hopper, Direction.UP), iv -> true, 1L, null);
            cir.setReturnValue((Object)(moved == 1L ? 1 : 0));
        }
    }
}

