/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.transfer.item;

import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.base.SingleStackStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.impl.transfer.DebugMessages;
import net.fabricmc.fabric.impl.transfer.item.InventoryStorageImpl;
import net.fabricmc.fabric.impl.transfer.item.ItemVariantImpl;
import net.fabricmc.fabric.impl.transfer.item.SpecialLogicInventory;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.block.entity.BlockEntity;
import net.minecraft.block.entity.BrewingStandBlockEntity;
import net.minecraft.block.entity.ChestBlockEntity;
import net.minecraft.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.block.enums.ChestType;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.property.Property;
import net.minecraft.util.math.BlockPos;

class InventorySlotWrapper
extends SingleStackStorage {
    private final InventoryStorageImpl storage;
    final int slot;
    private final SpecialLogicInventory specialInv;
    private ItemStack lastReleasedSnapshot = null;

    InventorySlotWrapper(InventoryStorageImpl storage, int slot) {
        SpecialLogicInventory specialInv;
        this.storage = storage;
        this.slot = slot;
        Inventory inventory = storage.inventory;
        this.specialInv = inventory instanceof SpecialLogicInventory ? (specialInv = (SpecialLogicInventory)inventory) : null;
    }

    @Override
    protected ItemStack getStack() {
        return this.storage.inventory.getStack(this.slot);
    }

    @Override
    protected void setStack(ItemStack stack) {
        if (this.specialInv == null) {
            this.storage.inventory.setStack(this.slot, stack);
        } else {
            this.specialInv.fabric_setSuppress(true);
            try {
                this.storage.inventory.setStack(this.slot, stack);
            }
            finally {
                this.specialInv.fabric_setSuppress(false);
            }
        }
    }

    @Override
    public long insert(ItemVariant insertedVariant, long maxAmount, TransactionContext transaction) {
        if (!this.canInsert(this.slot, ((ItemVariantImpl)insertedVariant).getCachedStack())) {
            return 0L;
        }
        long ret = super.insert(insertedVariant, maxAmount, transaction);
        if (this.specialInv != null && ret > 0L) {
            this.specialInv.fabric_onTransfer(this.slot, transaction);
        }
        return ret;
    }

    private boolean canInsert(int slot, ItemStack stack) {
        Inventory inventory = this.storage.inventory;
        if (inventory instanceof ShulkerBoxBlockEntity) {
            ShulkerBoxBlockEntity shulker = (ShulkerBoxBlockEntity)inventory;
            return shulker.canInsert(slot, stack, null);
        }
        return this.storage.inventory.isValid(slot, stack);
    }

    @Override
    public long extract(ItemVariant variant, long maxAmount, TransactionContext transaction) {
        long ret = super.extract(variant, maxAmount, transaction);
        if (this.specialInv != null && ret > 0L) {
            this.specialInv.fabric_onTransfer(this.slot, transaction);
        }
        return ret;
    }

    @Override
    public int getCapacity(ItemVariant variant) {
        if (this.storage.inventory instanceof AbstractFurnaceBlockEntity && this.slot == 1 && variant.isOf(Items.BUCKET)) {
            return 1;
        }
        if (this.storage.inventory instanceof BrewingStandBlockEntity && this.slot < 3) {
            return 1;
        }
        return Math.min(this.storage.inventory.getMaxCountPerStack(), variant.getItem().getMaxCount());
    }

    @Override
    public void updateSnapshots(TransactionContext transaction) {
        ChestBlockEntity chest;
        this.storage.markDirtyParticipant.updateSnapshots(transaction);
        super.updateSnapshots(transaction);
        Inventory inventory = this.storage.inventory;
        if (inventory instanceof ChestBlockEntity && (chest = (ChestBlockEntity)inventory).getCachedState().get((Property)ChestBlock.CHEST_TYPE) != ChestType.SINGLE) {
            BlockPos otherChestPos = chest.getPos().offset(ChestBlock.getFacing((BlockState)chest.getCachedState()));
            BlockEntity blockEntity = chest.getWorld().getBlockEntity(otherChestPos);
            if (blockEntity instanceof ChestBlockEntity) {
                ChestBlockEntity otherChest = (ChestBlockEntity)blockEntity;
                ((InventoryStorageImpl)InventoryStorageImpl.of((Inventory)otherChest, null)).markDirtyParticipant.updateSnapshots(transaction);
            }
        }
    }

    @Override
    protected void releaseSnapshot(ItemStack snapshot) {
        this.lastReleasedSnapshot = snapshot;
    }

    @Override
    protected void onFinalCommit() {
        ItemStack original = this.lastReleasedSnapshot;
        ItemStack currentStack = this.getStack();
        Inventory inventory = this.storage.inventory;
        if (inventory instanceof SpecialLogicInventory) {
            SpecialLogicInventory specialLogicInv = (SpecialLogicInventory)inventory;
            specialLogicInv.fabric_onFinalCommit(this.slot, original, currentStack);
        }
        if (!original.isEmpty() && original.getItem() == currentStack.getItem()) {
            original.setCount(currentStack.getCount());
            original.setNbt(currentStack.hasNbt() ? currentStack.getNbt().copy() : null);
            this.setStack(original);
        } else {
            original.setCount(0);
        }
    }

    @Override
    public String toString() {
        return "InventorySlotWrapper[%s#%d]".formatted(DebugMessages.forInventory(this.storage.inventory), this.slot);
    }
}

