/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.transfer.v1.fluid;

import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.impl.transfer.DebugMessages;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.sound.SoundCategory;
import net.minecraft.sound.SoundEvent;
import net.minecraft.sound.SoundEvents;
import net.minecraft.util.Hand;
import net.minecraft.util.crash.CrashException;
import net.minecraft.util.crash.CrashReport;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public final class FluidStorageUtil {
    public static boolean interactWithFluidStorage(Storage<FluidVariant> storage, PlayerEntity player, Hand hand) {
        Storage<FluidVariant> handStorage = ContainerItemContext.forPlayerInteraction(player, hand).find(FluidStorage.ITEM);
        if (handStorage == null) {
            return false;
        }
        Item handItem = player.getStackInHand(hand).getItem();
        try {
            return FluidStorageUtil.moveWithSound(storage, handStorage, player, true, handItem) || FluidStorageUtil.moveWithSound(handStorage, storage, player, false, handItem);
        }
        catch (Exception e) {
            CrashReport report = CrashReport.create((Throwable)e, (String)"Interacting with fluid storage");
            report.addElement("Interaction details").add("Player", () -> DebugMessages.forPlayer(player)).add("Hand", (Object)hand).add("Hand item", () -> ((Item)handItem).toString()).add("Fluid storage", () -> Objects.toString(storage, null));
            throw new CrashException(report);
        }
    }

    private static boolean moveWithSound(Storage<FluidVariant> from, Storage<FluidVariant> to, PlayerEntity player, boolean fill, Item handItem) {
        for (StorageView<FluidVariant> storageView : from) {
            long maxExtracted;
            if (storageView.isResourceBlank()) continue;
            FluidVariant resource = storageView.getResource();
            try (Transaction extractionTestTransaction = Transaction.openOuter();){
                maxExtracted = storageView.extract(resource, Long.MAX_VALUE, extractionTestTransaction);
                extractionTestTransaction.abort();
            }
            Transaction transferTransaction = Transaction.openOuter();
            try {
                SoundEvent sound;
                long accepted = to.insert(resource, maxExtracted, transferTransaction);
                if (accepted <= 0L || storageView.extract(resource, accepted, transferTransaction) != accepted) continue;
                transferTransaction.commit();
                SoundEvent soundEvent = sound = fill ? FluidVariantAttributes.getFillSound(resource) : FluidVariantAttributes.getEmptySound(resource);
                if (resource.isOf(Fluids.WATER)) {
                    if (fill && handItem == Items.GLASS_BOTTLE) {
                        sound = SoundEvents.ITEM_BOTTLE_FILL;
                    }
                    if (!fill && handItem == Items.POTION) {
                        sound = SoundEvents.ITEM_BOTTLE_EMPTY;
                    }
                }
                player.playSound(sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
                boolean bl = true;
                return bl;
            }
            finally {
                if (transferTransaction == null) continue;
                transferTransaction.close();
            }
        }
        return false;
    }

    private FluidStorageUtil() {
    }
}

