/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.loot;

import net.fabricmc.fabric.api.loot.v2.LootTableSource;
import net.fabricmc.fabric.impl.resource.loader.BuiltinModResourcePackSource;
import net.fabricmc.fabric.impl.resource.loader.FabricResource;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackCreator;
import net.minecraft.resource.Resource;
import net.minecraft.resource.ResourceManager;
import net.minecraft.resource.ResourcePackSource;
import net.minecraft.util.Identifier;

public final class LootUtil {
    public static LootTableSource determineSource(Identifier lootTableId, ResourceManager resourceManager) {
        Identifier resourceId = new Identifier(lootTableId.getNamespace(), "loot_tables/%s.json".formatted(lootTableId.getPath()));
        Resource resource = resourceManager.getResource(resourceId).orElse(null);
        if (resource != null) {
            ResourcePackSource packSource = ((FabricResource)resource).getFabricPackSource();
            if (packSource == ResourcePackSource.BUILTIN) {
                return LootTableSource.VANILLA;
            }
            if (packSource == ModResourcePackCreator.RESOURCE_PACK_SOURCE || packSource instanceof BuiltinModResourcePackSource) {
                return LootTableSource.MOD;
            }
        }
        return LootTableSource.DATA_PACK;
    }
}

