/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.loot.v2;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.fabric.mixin.loot.LootTableAccessor;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.function.LootFunction;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public interface FabricLootTableBuilder {
    default public LootTable.Builder pool(LootPool pool) {
        throw new UnsupportedOperationException("Implemented via mixin");
    }

    default public LootTable.Builder apply(LootFunction function) {
        throw new UnsupportedOperationException("Implemented via mixin");
    }

    default public LootTable.Builder pools(Collection<? extends LootPool> pools) {
        throw new UnsupportedOperationException("Implemented via mixin");
    }

    default public LootTable.Builder apply(Collection<? extends LootFunction> functions) {
        throw new UnsupportedOperationException("Implemented via mixin");
    }

    default public LootTable.Builder modifyPools(Consumer<? super LootPool.Builder> modifier) {
        throw new UnsupportedOperationException("Implemented via mixin");
    }

    public static LootTable.Builder copyOf(LootTable table) {
        LootTable.Builder builder = LootTable.builder();
        LootTableAccessor accessor = (LootTableAccessor)table;
        builder.type(table.getType());
        builder.pools(List.of(accessor.fabric_getPools()));
        builder.apply(List.of(accessor.fabric_getFunctions()));
        builder.randomSequenceId(accessor.fabric_getRandomSequenceId());
        return builder;
    }
}

