/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.event.lifecycle.client;

import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientChunkEvents;
import net.minecraft.client.world.ClientChunkManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.network.packet.s2c.play.ChunkData;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.WorldChunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Environment(value=EnvType.CLIENT)
@Mixin(value={ClientChunkManager.class})
public abstract class ClientChunkManagerMixin {
    @Final
    @Shadow
    private ClientWorld field_16525;

    @Inject(method={"loadChunkFromPacket"}, at={@At(value="TAIL")})
    private void onChunkLoad(int x, int z, PacketByteBuf packetByteBuf, NbtCompound nbtCompound, Consumer<ChunkData.BlockEntityVisitor> consumer, CallbackInfoReturnable<WorldChunk> info) {
        ((ClientChunkEvents.Load)ClientChunkEvents.CHUNK_LOAD.invoker()).onChunkLoad(this.field_16525, (WorldChunk)info.getReturnValue());
    }

    @Inject(method={"loadChunkFromPacket"}, at={@At(value="NEW", target="net/minecraft/world/chunk/WorldChunk", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void onChunkUnload(int x, int z, PacketByteBuf buf, NbtCompound tag, Consumer<ChunkData.BlockEntityVisitor> consumer, CallbackInfoReturnable<WorldChunk> info, int index, WorldChunk worldChunk, ChunkPos chunkPos) {
        if (worldChunk != null) {
            ((ClientChunkEvents.Unload)ClientChunkEvents.CHUNK_UNLOAD.invoker()).onChunkUnload(this.field_16525, worldChunk);
        }
    }

    @Inject(method={"unload"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/world/ClientChunkManager$ClientChunkMap;compareAndSet(ILnet/minecraft/world/chunk/WorldChunk;Lnet/minecraft/world/chunk/WorldChunk;)Lnet/minecraft/world/chunk/WorldChunk;")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private void onChunkUnload(int chunkX, int chunkZ, CallbackInfo ci, int i, WorldChunk chunk) {
        ((ClientChunkEvents.Unload)ClientChunkEvents.CHUNK_UNLOAD.invoker()).onChunkUnload(this.field_16525, chunk);
    }

    @Inject(method={"updateLoadDistance"}, at={@At(value="INVOKE", target="net/minecraft/client/world/ClientChunkManager$ClientChunkMap.isInRadius(II)Z")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void onUpdateLoadDistance(int loadDistance, CallbackInfo ci, int oldRadius, int newRadius, ClientChunkManager.ClientChunkMap clientChunkMap, int k, WorldChunk oldChunk, ChunkPos chunkPos) {
        if (!clientChunkMap.isInRadius(chunkPos.x, chunkPos.z)) {
            ((ClientChunkEvents.Unload)ClientChunkEvents.CHUNK_UNLOAD.invoker()).onChunkUnload(this.field_16525, oldChunk);
        }
    }
}

