/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.networking.v1;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fabricmc.fabric.mixin.networking.accessor.EntityTrackerAccessor;
import net.fabricmc.fabric.mixin.networking.accessor.ThreadedAnvilChunkStorageAccessor;
import net.minecraft.block.entity.BlockEntity;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.server.world.EntityTrackingListener;
import net.minecraft.server.world.ServerChunkManager;
import net.minecraft.server.world.ServerWorld;
import net.minecraft.server.world.ThreadedAnvilChunkStorage;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.chunk.ChunkManager;

public final class PlayerLookup {
    public static Collection<ServerPlayerEntity> all(MinecraftServer server) {
        Objects.requireNonNull(server, "The server cannot be null");
        if (server.getPlayerManager() != null) {
            return Collections.unmodifiableCollection(server.getPlayerManager().getPlayerList());
        }
        return Collections.emptyList();
    }

    public static Collection<ServerPlayerEntity> world(ServerWorld world) {
        Objects.requireNonNull(world, "The world cannot be null");
        return Collections.unmodifiableCollection(world.getPlayers());
    }

    public static Collection<ServerPlayerEntity> tracking(ServerWorld world, ChunkPos pos) {
        Objects.requireNonNull(world, "The world cannot be null");
        Objects.requireNonNull(pos, "The chunk pos cannot be null");
        return world.getChunkManager().threadedAnvilChunkStorage.getPlayersWatchingChunk(pos, false);
    }

    public static Collection<ServerPlayerEntity> tracking(Entity entity) {
        Objects.requireNonNull(entity, "Entity cannot be null");
        ChunkManager manager = entity.getWorld().getChunkManager();
        if (manager instanceof ServerChunkManager) {
            ThreadedAnvilChunkStorage storage = ((ServerChunkManager)manager).threadedAnvilChunkStorage;
            EntityTrackerAccessor tracker = (EntityTrackerAccessor)((ThreadedAnvilChunkStorageAccessor)storage).getEntityTrackers().get(entity.getId());
            if (tracker != null) {
                return Collections.unmodifiableCollection(tracker.getPlayersTracking().stream().map(EntityTrackingListener::getPlayer).collect(Collectors.toSet()));
            }
            return Collections.emptySet();
        }
        throw new IllegalArgumentException("Only supported on server worlds!");
    }

    public static Collection<ServerPlayerEntity> tracking(BlockEntity blockEntity) {
        Objects.requireNonNull(blockEntity, "BlockEntity cannot be null");
        if (!blockEntity.hasWorld() || blockEntity.getWorld().isClient()) {
            throw new IllegalArgumentException("Only supported on server worlds!");
        }
        return PlayerLookup.tracking((ServerWorld)blockEntity.getWorld(), blockEntity.getPos());
    }

    public static Collection<ServerPlayerEntity> tracking(ServerWorld world, BlockPos pos) {
        Objects.requireNonNull(pos, "BlockPos cannot be null");
        return PlayerLookup.tracking(world, new ChunkPos(pos));
    }

    public static Collection<ServerPlayerEntity> around(ServerWorld world, Vec3d pos, double radius) {
        double radiusSq = radius * radius;
        return PlayerLookup.world(world).stream().filter(p -> p.squaredDistanceTo(pos) <= radiusSq).collect(Collectors.toList());
    }

    public static Collection<ServerPlayerEntity> around(ServerWorld world, Vec3i pos, double radius) {
        double radiusSq = radius * radius;
        return PlayerLookup.world(world).stream().filter(p -> p.squaredDistanceTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) <= radiusSq).collect(Collectors.toList());
    }

    private PlayerLookup() {
    }
}

