/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.networking.v1;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Objects;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.impl.networking.GenericFutureListenerHolder;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.network.PacketCallbacks;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.Identifier;
import org.jetbrains.annotations.Nullable;

public interface PacketSender {
    public Packet<?> createPacket(Identifier var1, PacketByteBuf var2);

    public void sendPacket(Packet<?> var1);

    default public <T extends FabricPacket> void sendPacket(T packet) {
        PacketByteBuf buf = PacketByteBufs.create();
        packet.write(buf);
        this.sendPacket(packet.getType().getId(), buf);
    }

    public void sendPacket(Packet<?> var1, @Nullable GenericFutureListener<? extends Future<? super Void>> var2);

    default public <T extends FabricPacket> void sendPacket(T packet, @Nullable GenericFutureListener<? extends Future<? super Void>> callback) {
        PacketByteBuf buf = PacketByteBufs.create();
        packet.write(buf);
        this.sendPacket(packet.getType().getId(), buf, callback);
    }

    public void sendPacket(Packet<?> var1, @Nullable PacketCallbacks var2);

    default public <T extends FabricPacket> void sendPacket(T packet, @Nullable PacketCallbacks callback) {
        PacketByteBuf buf = PacketByteBufs.create();
        packet.write(buf);
        this.sendPacket(packet.getType().getId(), buf, callback);
    }

    default public void sendPacket(Identifier channel, PacketByteBuf buf) {
        Objects.requireNonNull(channel, "Channel cannot be null");
        Objects.requireNonNull(buf, "Payload cannot be null");
        this.sendPacket((FabricPacket)this.createPacket(channel, buf));
    }

    default public void sendPacket(Identifier channel, PacketByteBuf buf, @Nullable GenericFutureListener<? extends Future<? super Void>> callback) {
        this.sendPacket(channel, buf, GenericFutureListenerHolder.create(callback));
    }

    default public void sendPacket(Identifier channel, PacketByteBuf buf, @Nullable PacketCallbacks callback) {
        Objects.requireNonNull(channel, "Channel cannot be null");
        Objects.requireNonNull(buf, "Payload cannot be null");
        this.sendPacket((FabricPacket)this.createPacket(channel, buf), callback);
    }
}

