/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.lookup.block;

import net.fabricmc.fabric.api.event.lifecycle.v1.ServerBlockEntityEvents;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.impl.lookup.block.BlockApiLookupImpl;
import net.fabricmc.fabric.impl.lookup.block.ServerWorldCache;
import net.minecraft.block.BlockState;
import net.minecraft.block.entity.BlockEntity;
import net.minecraft.server.world.ServerWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public final class BlockApiCacheImpl<A, C>
implements BlockApiCache<A, C> {
    private final BlockApiLookupImpl<A, C> lookup;
    private final ServerWorld world;
    private final BlockPos pos;
    private boolean blockEntityCacheValid = false;
    private BlockEntity cachedBlockEntity = null;
    private BlockState lastState = null;
    private BlockApiLookup.BlockApiProvider<A, C> cachedProvider = null;

    public BlockApiCacheImpl(BlockApiLookupImpl<A, C> lookup, ServerWorld world, BlockPos pos) {
        ((ServerWorldCache)world).fabric_registerCache(pos, this);
        this.lookup = lookup;
        this.world = world;
        this.pos = pos.toImmutable();
    }

    public void invalidate() {
        this.blockEntityCacheValid = false;
        this.cachedBlockEntity = null;
        this.lastState = null;
        this.cachedProvider = null;
    }

    @Override
    @Nullable
    public A find(@Nullable BlockState state, C context) {
        this.getBlockEntity();
        if (state == null) {
            state = this.cachedBlockEntity != null ? this.cachedBlockEntity.getCachedState() : this.world.getBlockState(this.pos);
        }
        if (this.lastState != state) {
            this.cachedProvider = this.lookup.getProvider(state.getBlock());
            this.lastState = state;
        }
        A instance = null;
        if (this.cachedProvider != null) {
            instance = this.cachedProvider.find((World)this.world, this.pos, state, this.cachedBlockEntity, context);
        }
        if (instance != null) {
            return instance;
        }
        for (BlockApiLookup.BlockApiProvider<A, C> fallbackProvider : this.lookup.getFallbackProviders()) {
            instance = fallbackProvider.find((World)this.world, this.pos, state, this.cachedBlockEntity, context);
            if (instance == null) continue;
            return instance;
        }
        return null;
    }

    @Override
    @Nullable
    public BlockEntity getBlockEntity() {
        if (!this.blockEntityCacheValid) {
            this.cachedBlockEntity = this.world.getBlockEntity(this.pos);
            this.blockEntityCacheValid = true;
        }
        return this.cachedBlockEntity;
    }

    @Override
    public BlockApiLookupImpl<A, C> getLookup() {
        return this.lookup;
    }

    @Override
    public ServerWorld getWorld() {
        return this.world;
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    static {
        ServerBlockEntityEvents.BLOCK_ENTITY_LOAD.register((blockEntity, world) -> ((ServerWorldCache)world).fabric_invalidateCache(blockEntity.getPos()));
        ServerBlockEntityEvents.BLOCK_ENTITY_UNLOAD.register((blockEntity, world) -> ((ServerWorldCache)world).fabric_invalidateCache(blockEntity.getPos()));
    }
}

