/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource.loader;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.resource.ModResourcePack;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackUtil;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.resource.AbstractFileResourcePack;
import net.minecraft.resource.InputSupplier;
import net.minecraft.resource.ResourcePack;
import net.minecraft.resource.ResourceType;
import net.minecraft.resource.metadata.ResourceMetadataReader;
import net.minecraft.util.Identifier;
import net.minecraft.util.PathUtil;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModNioResourcePack
implements ResourcePack,
ModResourcePack {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModNioResourcePack.class);
    private static final Pattern RESOURCE_PACK_PATH = Pattern.compile("[a-z0-9-_.]+");
    private static final FileSystem DEFAULT_FS = FileSystems.getDefault();
    private final String id;
    private final ModMetadata modInfo;
    private final List<Path> basePaths;
    private final ResourceType type;
    private final AutoCloseable closer;
    private final ResourcePackActivationType activationType;
    private final Map<ResourceType, Set<String>> namespaces;
    private static final String resPrefix = ResourceType.CLIENT_RESOURCES.getDirectory() + "/";
    private static final String dataPrefix = ResourceType.SERVER_DATA.getDirectory() + "/";

    public static ModNioResourcePack create(String id, ModContainer mod, String subPath, ResourceType type, ResourcePackActivationType activationType) {
        ArrayList<Path> paths;
        ArrayList<Path> rootPaths = mod.getRootPaths();
        if (subPath == null) {
            paths = rootPaths;
        } else {
            paths = new ArrayList<Path>(rootPaths.size());
            for (Path path : rootPaths) {
                Path childPath = (path = path.toAbsolutePath().normalize()).resolve(subPath.replace("/", path.getFileSystem().getSeparator())).normalize();
                if (!childPath.startsWith(path) || !ModNioResourcePack.exists(childPath)) continue;
                paths.add(childPath);
            }
        }
        if (paths.isEmpty()) {
            return null;
        }
        ModNioResourcePack ret = new ModNioResourcePack(id, mod.getMetadata(), paths, type, null, activationType);
        return ret.getNamespaces(type).isEmpty() ? null : ret;
    }

    private ModNioResourcePack(String id, ModMetadata modInfo, List<Path> paths, ResourceType type, AutoCloseable closer, ResourcePackActivationType activationType) {
        this.id = id;
        this.modInfo = modInfo;
        this.basePaths = paths;
        this.type = type;
        this.closer = closer;
        this.activationType = activationType;
        this.namespaces = ModNioResourcePack.readNamespaces(paths, modInfo.getId());
    }

    static Map<ResourceType, Set<String>> readNamespaces(List<Path> paths, String modId) {
        EnumMap<ResourceType, Set<String>> ret = new EnumMap<ResourceType, Set<String>>(ResourceType.class);
        for (ResourceType type : ResourceType.values()) {
            Set namespaces = null;
            for (Path path : paths) {
                Path dir = path.resolve(type.getDirectory());
                if (!Files.isDirectory(dir, new LinkOption[0])) continue;
                String separator = path.getFileSystem().getSeparator();
                try {
                    DirectoryStream<Path> ds = Files.newDirectoryStream(dir);
                    try {
                        for (Path p : ds) {
                            if (!Files.isDirectory(p, new LinkOption[0])) continue;
                            String s = p.getFileName().toString();
                            if (!RESOURCE_PACK_PATH.matcher(s = s.replace(separator, "")).matches()) {
                                LOGGER.warn("Fabric NioResourcePack: ignored invalid namespace: {} in mod ID {}", (Object)s, (Object)modId);
                                continue;
                            }
                            if (namespaces == null) {
                                namespaces = new HashSet();
                            }
                            namespaces.add(s);
                        }
                    }
                    finally {
                        if (ds == null) continue;
                        ds.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("getNamespaces in mod " + modId + " failed!", (Throwable)e);
                }
            }
            ret.put(type, namespaces != null ? namespaces : Collections.emptySet());
        }
        return ret;
    }

    private Path getPath(String filename) {
        if (this.hasAbsentNs(filename)) {
            return null;
        }
        for (Path basePath : this.basePaths) {
            Path childPath = basePath.resolve(filename.replace("/", basePath.getFileSystem().getSeparator())).toAbsolutePath().normalize();
            if (!childPath.startsWith(basePath) || !ModNioResourcePack.exists(childPath)) continue;
            return childPath;
        }
        return null;
    }

    private boolean hasAbsentNs(String filename) {
        ResourceType type;
        int prefixLen;
        if (filename.startsWith(resPrefix)) {
            prefixLen = resPrefix.length();
            type = ResourceType.CLIENT_RESOURCES;
        } else if (filename.startsWith(dataPrefix)) {
            prefixLen = dataPrefix.length();
            type = ResourceType.SERVER_DATA;
        } else {
            return false;
        }
        int nsEnd = filename.indexOf(47, prefixLen);
        if (nsEnd < 0) {
            return false;
        }
        return !this.namespaces.get(type).contains(filename.substring(prefixLen, nsEnd));
    }

    private InputSupplier<InputStream> openFile(String filename) {
        Path path = this.getPath(filename);
        if (path != null && Files.isRegularFile(path, new LinkOption[0])) {
            return () -> Files.newInputStream(path, new OpenOption[0]);
        }
        if (ModResourcePackUtil.containsDefault(this.modInfo, filename)) {
            return () -> ModResourcePackUtil.openDefault(this.modInfo, this.type, filename);
        }
        return null;
    }

    @Nullable
    public InputSupplier<InputStream> openRoot(String ... pathSegments) {
        PathUtil.validatePath((String[])pathSegments);
        return this.openFile(String.join((CharSequence)"/", pathSegments));
    }

    @Nullable
    public InputSupplier<InputStream> open(ResourceType type, Identifier id) {
        Path path = this.getPath(ModNioResourcePack.getFilename(type, id));
        return path == null ? null : InputSupplier.create((Path)path);
    }

    public void findResources(ResourceType type, final String namespace, String path, final ResourcePack.ResultConsumer visitor) {
        if (!this.namespaces.getOrDefault(type, Collections.emptySet()).contains(namespace)) {
            return;
        }
        for (Path basePath : this.basePaths) {
            final String separator = basePath.getFileSystem().getSeparator();
            final Path nsPath = basePath.resolve(type.getDirectory()).resolve(namespace);
            Path searchPath = nsPath.resolve(path.replace("/", separator)).normalize();
            if (!ModNioResourcePack.exists(searchPath)) continue;
            try {
                Files.walkFileTree(searchPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        String filename = nsPath.relativize(file).toString().replace(separator, "/");
                        Identifier identifier = Identifier.of((String)namespace, (String)filename);
                        if (identifier == null) {
                            LOGGER.error("Invalid path in mod resource-pack {}: {}:{}, ignoring", new Object[]{ModNioResourcePack.this.id, namespace, filename});
                        } else {
                            visitor.accept((Object)identifier, (Object)InputSupplier.create((Path)file));
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                LOGGER.warn("findResources at " + path + " in namespace " + namespace + ", mod " + this.modInfo.getId() + " failed!", (Throwable)e);
            }
        }
    }

    public Set<String> getNamespaces(ResourceType type) {
        return this.namespaces.getOrDefault(type, Collections.emptySet());
    }

    public <T> T parseMetadata(ResourceMetadataReader<T> metaReader) throws IOException {
        try (InputStream is = (InputStream)this.openFile("pack.mcmeta").get();){
            Object object = AbstractFileResourcePack.parseMetadata(metaReader, (InputStream)is);
            return (T)object;
        }
    }

    public void close() {
        if (this.closer != null) {
            try {
                this.closer.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public ModMetadata getFabricModMetadata() {
        return this.modInfo;
    }

    public ResourcePackActivationType getActivationType() {
        return this.activationType;
    }

    public String getName() {
        return this.id;
    }

    private static boolean exists(Path path) {
        return path.getFileSystem() == DEFAULT_FS ? path.toFile().exists() : Files.exists(path, new LinkOption[0]);
    }

    private static String getFilename(ResourceType type, Identifier id) {
        return String.format(Locale.ROOT, "%s/%s/%s", type.getDirectory(), id.getNamespace(), id.getPath());
    }
}

