/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.recipe.ingredient.builtin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.recipe.Ingredient;
import net.minecraft.util.Identifier;

public class DifferenceIngredient
implements CustomIngredient {
    public static final CustomIngredientSerializer<DifferenceIngredient> SERIALIZER = new Serializer();
    private final Ingredient base;
    private final Ingredient subtracted;

    public DifferenceIngredient(Ingredient base, Ingredient subtracted) {
        this.base = base;
        this.subtracted = subtracted;
    }

    @Override
    public boolean test(ItemStack stack) {
        return this.base.test(stack) && !this.subtracted.test(stack);
    }

    @Override
    public List<ItemStack> getMatchingStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(List.of(this.base.getMatchingStacks()));
        stacks.removeIf((Predicate<ItemStack>)this.subtracted);
        return stacks;
    }

    @Override
    public boolean requiresTesting() {
        return this.base.requiresTesting() || this.subtracted.requiresTesting();
    }

    @Override
    public CustomIngredientSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    private static class Serializer
    implements CustomIngredientSerializer<DifferenceIngredient> {
        private final Identifier id = new Identifier("fabric", "difference");

        private Serializer() {
        }

        @Override
        public Identifier getIdentifier() {
            return this.id;
        }

        @Override
        public DifferenceIngredient read(JsonObject json) {
            Ingredient base = Ingredient.fromJson((JsonElement)json.get("base"));
            Ingredient subtracted = Ingredient.fromJson((JsonElement)json.get("subtracted"));
            return new DifferenceIngredient(base, subtracted);
        }

        @Override
        public void write(JsonObject json, DifferenceIngredient ingredient) {
            json.add("base", ingredient.base.toJson());
            json.add("subtracted", ingredient.subtracted.toJson());
        }

        @Override
        public DifferenceIngredient read(PacketByteBuf buf) {
            Ingredient base = Ingredient.fromPacket((PacketByteBuf)buf);
            Ingredient subtracted = Ingredient.fromPacket((PacketByteBuf)buf);
            return new DifferenceIngredient(base, subtracted);
        }

        @Override
        public void write(PacketByteBuf buf, DifferenceIngredient ingredient) {
            ingredient.base.write(buf);
            ingredient.subtracted.write(buf);
        }
    }
}

