/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.client.model.loading;

import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.client.model.loading.ModelLoaderHooks;
import net.fabricmc.fabric.impl.client.model.loading.ModelLoadingEventDispatcher;
import net.fabricmc.fabric.impl.client.model.loading.ModelLoadingPluginManager;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.render.model.ModelLoader;
import net.minecraft.client.render.model.UnbakedModel;
import net.minecraft.client.render.model.json.JsonUnbakedModel;
import net.minecraft.client.util.ModelIdentifier;
import net.minecraft.util.Identifier;
import net.minecraft.util.profiler.Profiler;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={ModelLoader.class})
public abstract class ModelLoaderMixin
implements ModelLoaderHooks {
    @Final
    @Shadow
    public static ModelIdentifier field_5374;
    @Final
    @Shadow
    private Set<Identifier> field_5390;
    @Final
    @Shadow
    private Map<Identifier, UnbakedModel> field_5376;
    @Shadow
    @Final
    private Map<Identifier, UnbakedModel> field_5394;
    @Unique
    private ModelLoadingEventDispatcher fabric_eventDispatcher;
    private int fabric_guardGetOrLoadModel = 0;
    private boolean fabric_enableGetOrLoadModelGuard = true;

    @Shadow
    private void method_4727(ModelIdentifier id) {
    }

    @Shadow
    public abstract UnbakedModel method_4726(Identifier var1);

    @Shadow
    private void method_4715(Identifier id) {
    }

    @Shadow
    private void method_4729(Identifier id, UnbakedModel unbakedModel) {
    }

    @Shadow
    public abstract JsonUnbakedModel method_4718(Identifier var1);

    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="net/minecraft/util/profiler/Profiler.swap(Ljava/lang/String;)V", ordinal=0)})
    private void afterMissingModelInit(BlockColors blockColors, Profiler profiler, Map<Identifier, JsonUnbakedModel> jsonUnbakedModels, Map<Identifier, List<ModelLoader.SourceTrackedData>> blockStates, CallbackInfo info) {
        if (!this.field_5376.containsKey(field_5374)) {
            throw new AssertionError((Object)"Missing model not initialized. This is likely a Fabric API porting bug.");
        }
        profiler.swap("fabric_plugins_init");
        this.fabric_eventDispatcher = new ModelLoadingEventDispatcher((ModelLoader)this, ModelLoadingPluginManager.CURRENT_PLUGINS.get());
        ModelLoadingPluginManager.CURRENT_PLUGINS.remove();
        this.fabric_eventDispatcher.addExtraModels(this::addModel);
    }

    @Unique
    private void addModel(Identifier id) {
        if (id instanceof ModelIdentifier) {
            this.method_4727((ModelIdentifier)id);
        } else {
            UnbakedModel unbakedModel = this.method_4726(id);
            this.field_5376.put(id, unbakedModel);
            this.field_5394.put(id, unbakedModel);
        }
    }

    @Inject(method={"getOrLoadModel"}, at={@At(value="HEAD")})
    private void fabric_preventNestedGetOrLoadModel(Identifier id, CallbackInfoReturnable<UnbakedModel> cir) {
        if (this.fabric_enableGetOrLoadModelGuard && this.fabric_guardGetOrLoadModel > 0) {
            throw new IllegalStateException("ModelLoader#getOrLoadModel called from a ModelResolver or ModelModifier.OnBake instance. This is not allowed to prevent errors during model loading. Use getOrLoadModel from the context instead.");
        }
    }

    @Inject(method={"loadModel"}, at={@At(value="HEAD")}, cancellable=true)
    private void onLoadModel(Identifier id, CallbackInfo ci) {
        ++this.fabric_guardGetOrLoadModel;
        try {
            if (this.fabric_eventDispatcher.loadModel(id)) {
                ci.cancel();
            }
        }
        finally {
            --this.fabric_guardGetOrLoadModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ModifyVariable(method={"putModel"}, at=@At(value="HEAD"), argsOnly=true)
    private UnbakedModel onPutModel(UnbakedModel model, Identifier id) {
        ++this.fabric_guardGetOrLoadModel;
        try {
            UnbakedModel unbakedModel = this.fabric_eventDispatcher.modifyModelOnLoad(id, model);
            return unbakedModel;
        }
        finally {
            --this.fabric_guardGetOrLoadModel;
        }
    }

    @Override
    public ModelLoadingEventDispatcher fabric_getDispatcher() {
        return this.fabric_eventDispatcher;
    }

    @Override
    public UnbakedModel fabric_getMissingModel() {
        return this.field_5376.get(field_5374);
    }

    @Override
    public UnbakedModel fabric_getOrLoadModel(Identifier id) {
        if (this.field_5376.containsKey(id)) {
            return this.field_5376.get(id);
        }
        if (!this.field_5390.add(id)) {
            throw new IllegalStateException("Circular reference while loading " + String.valueOf(id));
        }
        try {
            this.method_4715(id);
        }
        finally {
            this.field_5390.remove(id);
        }
        return this.field_5376.get(id);
    }

    @Override
    public void fabric_putModel(Identifier id, UnbakedModel model) {
        this.method_4729(id, model);
    }

    @Override
    public void fabric_putModelDirectly(Identifier id, UnbakedModel model) {
        this.field_5376.put(id, model);
    }

    @Override
    public void fabric_queueModelDependencies(UnbakedModel model) {
        this.field_5390.addAll(model.getModelDependencies());
    }

    @Override
    public JsonUnbakedModel fabric_loadModelFromJson(Identifier id) {
        return this.method_4718(id);
    }
}

