/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.model.loading;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.loading.v1.BlockStateResolver;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelModifier;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelResolver;
import net.fabricmc.fabric.impl.client.model.loading.BlockStateResolverHolder;
import net.fabricmc.fabric.impl.client.model.loading.LegacyModelVariantProvider;
import net.fabricmc.fabric.impl.client.model.loading.ModelLoaderHooks;
import net.fabricmc.fabric.impl.client.model.loading.ModelLoaderPluginContextImpl;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.render.block.BlockModels;
import net.minecraft.client.render.model.BakedModel;
import net.minecraft.client.render.model.Baker;
import net.minecraft.client.render.model.ModelBakeSettings;
import net.minecraft.client.render.model.ModelLoader;
import net.minecraft.client.render.model.UnbakedModel;
import net.minecraft.client.texture.Sprite;
import net.minecraft.client.util.ModelIdentifier;
import net.minecraft.client.util.SpriteIdentifier;
import net.minecraft.util.Identifier;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class ModelLoadingEventDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelLoadingEventDispatcher.class);
    private final ModelLoader loader;
    private final ModelLoaderPluginContextImpl pluginContext;
    private final ObjectArrayList<ModelResolverContext> modelResolverContextStack = new ObjectArrayList();
    private final ObjectArrayList<BlockStateResolverContext> blockStateResolverContextStack = new ObjectArrayList();
    private final ReferenceSet<Block> resolvingBlocks = new ReferenceOpenHashSet();
    private final ObjectArrayList<OnLoadModifierContext> onLoadModifierContextStack = new ObjectArrayList();
    private final ObjectArrayList<BeforeBakeModifierContext> beforeBakeModifierContextStack = new ObjectArrayList();
    private final ObjectArrayList<AfterBakeModifierContext> afterBakeModifierContextStack = new ObjectArrayList();

    public ModelLoadingEventDispatcher(ModelLoader loader, List<ModelLoadingPlugin> plugins) {
        this.loader = loader;
        this.pluginContext = new ModelLoaderPluginContextImpl(((ModelLoaderHooks)loader)::fabric_getOrLoadModel);
        for (ModelLoadingPlugin plugin : plugins) {
            try {
                plugin.onInitializeModelLoader(this.pluginContext);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to initialize model loading plugin", (Throwable)exception);
            }
        }
    }

    public void addExtraModels(Consumer<Identifier> extraModelConsumer) {
        for (Identifier id : this.pluginContext.extraModels) {
            extraModelConsumer.accept(id);
        }
    }

    public boolean loadModel(Identifier id) {
        if (id instanceof ModelIdentifier) {
            ModelIdentifier modelId = (ModelIdentifier)id;
            if ("inventory".equals(modelId.getVariant())) {
                this.loadItemModel(modelId);
                return true;
            }
            BlockStateResolverHolder resolver = this.pluginContext.getBlockStateResolver(modelId);
            if (resolver != null) {
                this.loadBlockStateModels(resolver.resolver(), resolver.block(), resolver.blockId());
                return true;
            }
            UnbakedModel legacyModel = this.legacyLoadModelVariant(modelId);
            if (legacyModel != null) {
                ((ModelLoaderHooks)this.loader).fabric_putModel(id, legacyModel);
                return true;
            }
            return false;
        }
        UnbakedModel model = this.resolveModel(id);
        if (model != null) {
            ((ModelLoaderHooks)this.loader).fabric_putModel(id, model);
            return true;
        }
        return false;
    }

    @Nullable
    private UnbakedModel legacyLoadModelVariant(ModelIdentifier modelId) {
        return ((LegacyModelVariantProvider)this.pluginContext.legacyVariantProviders().invoker()).loadModelVariant(modelId);
    }

    private void loadItemModel(ModelIdentifier modelId) {
        ModelLoaderHooks loaderHooks = (ModelLoaderHooks)this.loader;
        Identifier id = modelId.withPrefixedPath("item/");
        UnbakedModel model = this.legacyLoadModelVariant(modelId);
        if (model == null) {
            model = this.resolveModel(id);
        }
        if (model == null) {
            model = loaderHooks.fabric_loadModelFromJson(id);
        }
        model = this.modifyModelOnLoad((Identifier)modelId, model);
        loaderHooks.fabric_putModelDirectly((Identifier)modelId, model);
        loaderHooks.fabric_putModelDirectly(id, model);
        loaderHooks.fabric_queueModelDependencies(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBlockStateModels(BlockStateResolver resolver, Block block, Identifier blockId) {
        if (!this.resolvingBlocks.add((Object)block)) {
            throw new IllegalStateException("Circular reference while resolving models for block " + String.valueOf(block));
        }
        try {
            this.resolveBlockStates(resolver, block, blockId);
        }
        finally {
            this.resolvingBlocks.remove((Object)block);
        }
    }

    private void resolveBlockStates(BlockStateResolver resolver, Block block, Identifier blockId) {
        if (this.blockStateResolverContextStack.isEmpty()) {
            this.blockStateResolverContextStack.add((Object)new BlockStateResolverContext());
        }
        BlockStateResolverContext context = (BlockStateResolverContext)this.blockStateResolverContextStack.pop();
        context.prepare(block);
        Reference2ReferenceMap<BlockState, UnbakedModel> resolvedModels = context.models;
        ImmutableList allStates = block.getStateManager().getStates();
        boolean thrown = false;
        try {
            resolver.resolveBlockStates(context);
        }
        catch (Exception e) {
            LOGGER.error("Failed to resolve block state models for block {}. Using missing model for all states.", (Object)block, (Object)e);
            thrown = true;
        }
        if (thrown) {
            UnbakedModel missingModel = ((ModelLoaderHooks)this.loader).fabric_getMissingModel();
            for (BlockState state2 : allStates) {
                ModelIdentifier modelId = BlockModels.getModelId((Identifier)blockId, (BlockState)state2);
                ((ModelLoaderHooks)this.loader).fabric_putModelDirectly((Identifier)modelId, missingModel);
            }
        } else if (resolvedModels.size() == allStates.size()) {
            resolvedModels.forEach((state, model) -> {
                ModelIdentifier modelId = BlockModels.getModelId((Identifier)blockId, (BlockState)state);
                ((ModelLoaderHooks)this.loader).fabric_putModel((Identifier)modelId, (UnbakedModel)model);
            });
        } else {
            UnbakedModel missingModel = ((ModelLoaderHooks)this.loader).fabric_getMissingModel();
            for (BlockState state3 : allStates) {
                ModelIdentifier modelId = BlockModels.getModelId((Identifier)blockId, (BlockState)state3);
                @Nullable UnbakedModel model2 = (UnbakedModel)resolvedModels.get((Object)state3);
                if (model2 == null) {
                    LOGGER.error("Block state resolver did not provide a model for state {} in block {}. Using missing model.", (Object)state3, (Object)block);
                    ((ModelLoaderHooks)this.loader).fabric_putModelDirectly((Identifier)modelId, missingModel);
                    continue;
                }
                ((ModelLoaderHooks)this.loader).fabric_putModel((Identifier)modelId, model2);
            }
        }
        resolvedModels.clear();
        this.blockStateResolverContextStack.add((Object)context);
    }

    @Nullable
    private UnbakedModel resolveModel(Identifier id) {
        if (this.modelResolverContextStack.isEmpty()) {
            this.modelResolverContextStack.add((Object)new ModelResolverContext());
        }
        ModelResolverContext context = (ModelResolverContext)this.modelResolverContextStack.pop();
        context.prepare(id);
        UnbakedModel model = ((ModelResolver)this.pluginContext.resolveModel().invoker()).resolveModel(context);
        this.modelResolverContextStack.push((Object)context);
        return model;
    }

    public UnbakedModel modifyModelOnLoad(Identifier id, UnbakedModel model) {
        if (this.onLoadModifierContextStack.isEmpty()) {
            this.onLoadModifierContextStack.add((Object)new OnLoadModifierContext());
        }
        OnLoadModifierContext context = (OnLoadModifierContext)this.onLoadModifierContextStack.pop();
        context.prepare(id);
        model = ((ModelModifier.OnLoad)this.pluginContext.modifyModelOnLoad().invoker()).modifyModelOnLoad(model, context);
        this.onLoadModifierContextStack.push((Object)context);
        return model;
    }

    public UnbakedModel modifyModelBeforeBake(UnbakedModel model, Identifier id, Function<SpriteIdentifier, Sprite> textureGetter, ModelBakeSettings settings, Baker baker) {
        if (this.beforeBakeModifierContextStack.isEmpty()) {
            this.beforeBakeModifierContextStack.add((Object)new BeforeBakeModifierContext());
        }
        BeforeBakeModifierContext context = (BeforeBakeModifierContext)this.beforeBakeModifierContextStack.pop();
        context.prepare(id, textureGetter, settings, baker);
        model = ((ModelModifier.BeforeBake)this.pluginContext.modifyModelBeforeBake().invoker()).modifyModelBeforeBake(model, context);
        this.beforeBakeModifierContextStack.push((Object)context);
        return model;
    }

    @Nullable
    public BakedModel modifyModelAfterBake(@Nullable BakedModel model, Identifier id, UnbakedModel sourceModel, Function<SpriteIdentifier, Sprite> textureGetter, ModelBakeSettings settings, Baker baker) {
        if (this.afterBakeModifierContextStack.isEmpty()) {
            this.afterBakeModifierContextStack.add((Object)new AfterBakeModifierContext());
        }
        AfterBakeModifierContext context = (AfterBakeModifierContext)this.afterBakeModifierContextStack.pop();
        context.prepare(id, sourceModel, textureGetter, settings, baker);
        model = ((ModelModifier.AfterBake)this.pluginContext.modifyModelAfterBake().invoker()).modifyModelAfterBake(model, context);
        this.afterBakeModifierContextStack.push((Object)context);
        return model;
    }

    @Environment(value=EnvType.CLIENT)
    private class BlockStateResolverContext
    implements BlockStateResolver.Context {
        private Block block;
        private final Reference2ReferenceMap<BlockState, UnbakedModel> models = new Reference2ReferenceOpenHashMap();

        private BlockStateResolverContext() {
        }

        private void prepare(Block block) {
            this.block = block;
            this.models.clear();
        }

        @Override
        public Block block() {
            return this.block;
        }

        @Override
        public void setModel(BlockState state, UnbakedModel model) {
            Objects.requireNonNull(model, "state cannot be null");
            Objects.requireNonNull(model, "model cannot be null");
            if (!state.isOf(this.block)) {
                throw new IllegalArgumentException("Attempted to set model for state " + String.valueOf(state) + " on block " + String.valueOf(this.block));
            }
            if (this.models.putIfAbsent((Object)state, (Object)model) != null) {
                throw new IllegalStateException("Duplicate model for state " + String.valueOf(state) + " on block " + String.valueOf(this.block));
            }
        }

        @Override
        public UnbakedModel getOrLoadModel(Identifier id) {
            return ((ModelLoaderHooks)ModelLoadingEventDispatcher.this.loader).fabric_getOrLoadModel(id);
        }

        @Override
        public ModelLoader loader() {
            return ModelLoadingEventDispatcher.this.loader;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class ModelResolverContext
    implements ModelResolver.Context {
        private Identifier id;

        private ModelResolverContext() {
        }

        private void prepare(Identifier id) {
            this.id = id;
        }

        @Override
        public Identifier id() {
            return this.id;
        }

        @Override
        public UnbakedModel getOrLoadModel(Identifier id) {
            return ((ModelLoaderHooks)ModelLoadingEventDispatcher.this.loader).fabric_getOrLoadModel(id);
        }

        @Override
        public ModelLoader loader() {
            return ModelLoadingEventDispatcher.this.loader;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class OnLoadModifierContext
    implements ModelModifier.OnLoad.Context {
        private Identifier id;

        private OnLoadModifierContext() {
        }

        private void prepare(Identifier id) {
            this.id = id;
        }

        @Override
        public Identifier id() {
            return this.id;
        }

        @Override
        public UnbakedModel getOrLoadModel(Identifier id) {
            return ((ModelLoaderHooks)ModelLoadingEventDispatcher.this.loader).fabric_getOrLoadModel(id);
        }

        @Override
        public ModelLoader loader() {
            return ModelLoadingEventDispatcher.this.loader;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class BeforeBakeModifierContext
    implements ModelModifier.BeforeBake.Context {
        private Identifier id;
        private Function<SpriteIdentifier, Sprite> textureGetter;
        private ModelBakeSettings settings;
        private Baker baker;

        private BeforeBakeModifierContext() {
        }

        private void prepare(Identifier id, Function<SpriteIdentifier, Sprite> textureGetter, ModelBakeSettings settings, Baker baker) {
            this.id = id;
            this.textureGetter = textureGetter;
            this.settings = settings;
            this.baker = baker;
        }

        @Override
        public Identifier id() {
            return this.id;
        }

        @Override
        public Function<SpriteIdentifier, Sprite> textureGetter() {
            return this.textureGetter;
        }

        @Override
        public ModelBakeSettings settings() {
            return this.settings;
        }

        @Override
        public Baker baker() {
            return this.baker;
        }

        @Override
        public ModelLoader loader() {
            return ModelLoadingEventDispatcher.this.loader;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class AfterBakeModifierContext
    implements ModelModifier.AfterBake.Context {
        private Identifier id;
        private UnbakedModel sourceModel;
        private Function<SpriteIdentifier, Sprite> textureGetter;
        private ModelBakeSettings settings;
        private Baker baker;

        private AfterBakeModifierContext() {
        }

        private void prepare(Identifier id, UnbakedModel sourceModel, Function<SpriteIdentifier, Sprite> textureGetter, ModelBakeSettings settings, Baker baker) {
            this.id = id;
            this.sourceModel = sourceModel;
            this.textureGetter = textureGetter;
            this.settings = settings;
            this.baker = baker;
        }

        @Override
        public Identifier id() {
            return this.id;
        }

        @Override
        public UnbakedModel sourceModel() {
            return this.sourceModel;
        }

        @Override
        public Function<SpriteIdentifier, Sprite> textureGetter() {
            return this.textureGetter;
        }

        @Override
        public ModelBakeSettings settings() {
            return this.settings;
        }

        @Override
        public Baker baker() {
            return this.baker;
        }

        @Override
        public ModelLoader loader() {
            return ModelLoadingEventDispatcher.this.loader;
        }
    }
}

