/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.client.event.lifecycle.v1;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.world.ClientWorld;

@Environment(value=EnvType.CLIENT)
public final class ClientTickEvents {
    public static final Event<StartTick> START_CLIENT_TICK = EventFactory.createArrayBacked(StartTick.class, callbacks -> client -> {
        for (StartTick event : callbacks) {
            event.onStartTick(client);
        }
    });
    public static final Event<EndTick> END_CLIENT_TICK = EventFactory.createArrayBacked(EndTick.class, callbacks -> client -> {
        for (EndTick event : callbacks) {
            event.onEndTick(client);
        }
    });
    public static final Event<StartWorldTick> START_WORLD_TICK = EventFactory.createArrayBacked(StartWorldTick.class, callbacks -> world -> {
        for (StartWorldTick callback : callbacks) {
            callback.onStartTick(world);
        }
    });
    public static final Event<EndWorldTick> END_WORLD_TICK = EventFactory.createArrayBacked(EndWorldTick.class, callbacks -> world -> {
        for (EndWorldTick callback : callbacks) {
            callback.onEndTick(world);
        }
    });

    private ClientTickEvents() {
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface EndWorldTick {
        public void onEndTick(ClientWorld var1);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface StartWorldTick {
        public void onStartTick(ClientWorld var1);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface EndTick {
        public void onEndTick(MinecraftClient var1);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface StartTick {
        public void onStartTick(MinecraftClient var1);
    }
}

