/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking.v0;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.network.PacketConsumer;
import net.fabricmc.fabric.api.network.PacketContext;
import net.fabricmc.fabric.api.network.PacketRegistry;
import net.fabricmc.fabric.api.network.ServerSidePacketRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.impl.networking.GenericFutureListenerHolder;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.network.PacketCallbacks;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.s2c.play.CustomPayloadS2CPacket;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.util.Identifier;
import net.minecraft.util.thread.ThreadExecutor;

public class ServerSidePacketRegistryImpl
implements ServerSidePacketRegistry,
PacketRegistry {
    @Override
    public boolean canPlayerReceive(PlayerEntity player, Identifier id) {
        if (player instanceof ServerPlayerEntity) {
            return ServerPlayNetworking.canSend((ServerPlayerEntity)((ServerPlayerEntity)player), (Identifier)id);
        }
        return false;
    }

    @Override
    public void sendToPlayer(PlayerEntity player, Packet<?> packet, GenericFutureListener<? extends Future<? super Void>> completionListener) {
        if (player instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)player).networkHandler.sendPacket(packet, (PacketCallbacks)GenericFutureListenerHolder.create(completionListener));
            return;
        }
        throw new RuntimeException("Can only send to ServerPlayerEntities!");
    }

    @Override
    public Packet<?> toPacket(Identifier id, PacketByteBuf buf) {
        return new CustomPayloadS2CPacket(id, buf);
    }

    @Override
    public void register(Identifier id, PacketConsumer consumer) {
        Objects.requireNonNull(consumer, "PacketConsumer cannot be null");
        ServerPlayNetworking.registerGlobalReceiver((Identifier)id, (server, player, handler, buf, sender) -> consumer.accept(new PacketContext(){

            @Override
            public EnvType getPacketEnvironment() {
                return EnvType.SERVER;
            }

            @Override
            public PlayerEntity getPlayer() {
                return player;
            }

            public ThreadExecutor<?> getTaskQueue() {
                return server;
            }
        }, buf));
    }

    @Override
    public void unregister(Identifier id) {
        ServerPlayNetworking.unregisterGlobalReceiver((Identifier)id);
    }
}

