/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.itemgroup;

import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.client.itemgroup.CreativeGuiExtensions;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.gui.DrawContext;
import net.minecraft.client.gui.screen.ingame.CreativeInventoryScreen;
import net.minecraft.client.gui.widget.ButtonWidget;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemGroups;
import net.minecraft.registry.Registries;
import net.minecraft.registry.Registry;
import net.minecraft.text.Text;
import net.minecraft.util.Identifier;

@Environment(value=EnvType.CLIENT)
public class FabricCreativeGuiComponents {
    private static final Identifier BUTTON_TEX = new Identifier("fabric", "textures/gui/creative_buttons.png");
    public static final Set<ItemGroup> COMMON_GROUPS = Set.of(ItemGroups.SEARCH, ItemGroups.INVENTORY, ItemGroups.HOTBAR).stream().map(arg_0 -> ((Registry)Registries.ITEM_GROUP).getOrThrow(arg_0)).collect(Collectors.toSet());

    @Environment(value=EnvType.CLIENT)
    public static enum Type {
        NEXT((Text)Text.literal((String)">"), CreativeGuiExtensions::fabric_nextPage),
        PREVIOUS((Text)Text.literal((String)"<"), CreativeGuiExtensions::fabric_previousPage);

        final Text text;
        final Consumer<CreativeGuiExtensions> clickConsumer;

        private Type(Text text, Consumer<CreativeGuiExtensions> clickConsumer) {
            this.text = text;
            this.clickConsumer = clickConsumer;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ItemGroupButtonWidget
    extends ButtonWidget {
        final CreativeGuiExtensions extensions;
        final CreativeInventoryScreen gui;
        final Type type;

        public ItemGroupButtonWidget(int x, int y, Type type, CreativeGuiExtensions extensions) {
            super(x, y, 11, 12, type.text, bw -> type.clickConsumer.accept(extensions), ButtonWidget.DEFAULT_NARRATION_SUPPLIER);
            this.extensions = extensions;
            this.type = type;
            this.gui = (CreativeInventoryScreen)extensions;
        }

        public void render(DrawContext drawContext, int mouseX, int mouseY, float float_1) {
            this.hovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
            this.visible = this.extensions.fabric_isButtonVisible(this.type);
            this.active = this.extensions.fabric_isButtonEnabled(this.type);
            if (this.visible) {
                int u = this.active && this.isHovered() ? 22 : 0;
                int v = this.active ? 0 : 12;
                drawContext.drawTexture(BUTTON_TEX, this.getX(), this.getY(), u + (this.type == Type.NEXT ? 11 : 0), v, 11, 12);
                if (this.hovered) {
                    int pageCount = (int)Math.ceil((double)(ItemGroups.getGroupsToDisplay().size() - COMMON_GROUPS.size()) / 9.0);
                    drawContext.drawTooltip(MinecraftClient.getInstance().textRenderer, (Text)Text.translatable((String)"fabric.gui.creativeTabPage", (Object[])new Object[]{this.extensions.fabric_currentPage() + 1, pageCount}), mouseX, mouseY);
                }
            }
        }
    }
}

