/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.entity.event.v1;

import net.minecraft.entity.EquipmentSlot;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.ItemStack;
import net.minecraft.world.event.GameEvent;

public interface FabricElytraItem {
    default public boolean useCustomElytra(LivingEntity entity, ItemStack chestStack, boolean tickElytra) {
        if (ElytraItem.isUsable((ItemStack)chestStack)) {
            if (tickElytra) {
                this.doVanillaElytraTick(entity, chestStack);
            }
            return true;
        }
        return false;
    }

    default public void doVanillaElytraTick(LivingEntity entity, ItemStack chestStack) {
        int nextRoll = entity.getRoll() + 1;
        if (!entity.getWorld().isClient && nextRoll % 10 == 0) {
            if (nextRoll / 10 % 2 == 0) {
                chestStack.damage(1, entity, p -> p.sendEquipmentBreakStatus(EquipmentSlot.CHEST));
            }
            entity.emitGameEvent(GameEvent.ELYTRA_GLIDE);
        }
    }
}

