/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.mininglevel;

import net.fabricmc.fabric.api.mininglevel.v1.FabricMineableTags;
import net.fabricmc.fabric.api.mininglevel.v1.MiningLevelManager;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.item.ToolMaterial;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SwordItem.class})
abstract class SwordItemMixin
extends ToolItem {
    private SwordItemMixin(ToolMaterial material, Item.Settings settings) {
        super(material, settings);
    }

    @Inject(method={"isSuitableFor"}, at={@At(value="HEAD")}, cancellable=true)
    private void fabric$onIsSuitableFor(BlockState state, CallbackInfoReturnable<Boolean> info) {
        int miningLevel;
        if (state.isIn(FabricMineableTags.SWORD_MINEABLE) && (miningLevel = this.getMaterial().getMiningLevel()) >= MiningLevelManager.getRequiredMiningLevel(state)) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getMiningSpeedMultiplier"}, at={@At(value="RETURN")}, cancellable=true)
    private void fabric$onGetMiningSpeedMultiplier(ItemStack stack, BlockState state, CallbackInfoReturnable<Float> info) {
        if (info.getReturnValueF() == 1.0f && state.isIn(FabricMineableTags.SWORD_MINEABLE)) {
            info.setReturnValue((Object)Float.valueOf(this.getMaterial().getMiningSpeedMultiplier()));
        }
    }
}

