/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.mininglevel;

import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.minecraft.block.BlockState;
import net.minecraft.registry.tag.BlockTags;
import net.minecraft.registry.tag.TagKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MiningLevelManagerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-mining-level-api-v1/MiningLevelManagerImpl");
    private static final String TOOL_TAG_NAMESPACE = "fabric";
    private static final Pattern TOOL_TAG_PATTERN = Pattern.compile("^needs_tool_level_([0-9]+)$");
    private static final ThreadLocal<Reference2IntMap<BlockState>> CACHE = ThreadLocal.withInitial(Reference2IntOpenHashMap::new);

    public static int getRequiredMiningLevel(BlockState state) {
        return CACHE.get().computeIfAbsent((Object)state, s -> {
            int miningLevel = -1;
            for (TagKey tagId : state.streamTags().toList()) {
                Matcher matcher;
                if (!tagId.id().getNamespace().equals(TOOL_TAG_NAMESPACE) || !(matcher = TOOL_TAG_PATTERN.matcher(tagId.id().getPath())).matches()) continue;
                try {
                    int tagMiningLevel = Integer.parseInt(matcher.group(1));
                    miningLevel = Math.max(miningLevel, tagMiningLevel);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("Could not read mining level from tag #{}", (Object)tagId, (Object)e);
                }
            }
            if (state.isIn(BlockTags.NEEDS_DIAMOND_TOOL)) {
                miningLevel = Math.max(miningLevel, 3);
            } else if (state.isIn(BlockTags.NEEDS_IRON_TOOL)) {
                miningLevel = Math.max(miningLevel, 2);
            } else if (state.isIn(BlockTags.NEEDS_STONE_TOOL)) {
                miningLevel = Math.max(miningLevel, 1);
            }
            return miningLevel;
        });
    }

    static {
        CommonLifecycleEvents.TAGS_LOADED.register((registries, client) -> CACHE.get().clear());
    }
}

