/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.datagen.v1.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.impl.datagen.FabricDataGenHelper;
import net.minecraft.data.DataOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.DataWriter;
import net.minecraft.data.server.recipe.RecipeJsonProvider;
import net.minecraft.data.server.recipe.RecipeProvider;
import net.minecraft.util.Identifier;

public abstract class FabricRecipeProvider
extends RecipeProvider {
    protected final FabricDataOutput output;

    public FabricRecipeProvider(FabricDataOutput output) {
        super((DataOutput)output);
        this.output = output;
    }

    public abstract void generate(Consumer<RecipeJsonProvider> var1);

    protected Consumer<RecipeJsonProvider> withConditions(Consumer<RecipeJsonProvider> exporter, ConditionJsonProvider ... conditions) {
        Preconditions.checkArgument((conditions.length > 0 ? 1 : 0) != 0, (Object)"Must add at least one condition.");
        return json -> {
            FabricDataGenHelper.addConditions(json, conditions);
            exporter.accept((RecipeJsonProvider)json);
        };
    }

    public CompletableFuture<?> run(DataWriter writer) {
        HashSet generatedRecipes = Sets.newHashSet();
        ArrayList list = new ArrayList();
        this.generate(provider -> {
            Identifier identifier = this.getRecipeIdentifier(provider.getRecipeId());
            if (!generatedRecipes.add(identifier)) {
                throw new IllegalStateException("Duplicate recipe " + String.valueOf(identifier));
            }
            JsonObject recipeJson = provider.toJson();
            ConditionJsonProvider[] conditions = FabricDataGenHelper.consumeConditions(provider);
            ConditionJsonProvider.write((JsonObject)recipeJson, (ConditionJsonProvider[])conditions);
            list.add(DataProvider.writeToPath((DataWriter)writer, (JsonElement)recipeJson, (Path)this.recipesPathResolver.resolveJson(identifier)));
            JsonObject advancementJson = provider.toAdvancementJson();
            if (advancementJson != null) {
                ConditionJsonProvider.write((JsonObject)advancementJson, (ConditionJsonProvider[])conditions);
                list.add(DataProvider.writeToPath((DataWriter)writer, (JsonElement)advancementJson, (Path)this.advancementsPathResolver.resolveJson(this.getRecipeIdentifier(provider.getAdvancementId()))));
            }
        });
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    protected Identifier getRecipeIdentifier(Identifier identifier) {
        return new Identifier(this.output.getModId(), identifier.getPath());
    }
}

