/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.registry;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.world.event.GameEvent;
import net.minecraft.world.event.Vibrations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SculkSensorFrequencyRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(SculkSensorFrequencyRegistry.class);

    private SculkSensorFrequencyRegistry() {
    }

    public static void register(GameEvent event, int frequency) {
        if (frequency <= 0 || frequency >= 16) {
            throw new IllegalArgumentException("Attempted to register Sculk Sensor frequency for event " + event.getId() + " with frequency " + frequency + ". Sculk Sensor frequencies must be between 1 and 15 inclusive.");
        }
        Object2IntOpenHashMap map = (Object2IntOpenHashMap)Vibrations.FREQUENCIES;
        int replaced = map.put((Object)event, frequency);
        if (replaced != 0) {
            LOGGER.debug("Replaced old frequency mapping for {} - was {}, now {}", new Object[]{event.getId(), replaced, frequency});
        }
    }
}

