/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.screenhandler;

import com.mojang.authlib.GameProfile;
import java.util.Objects;
import java.util.OptionalInt;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.fabricmc.fabric.impl.screenhandler.Networking;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.packet.Packet;
import net.minecraft.registry.Registries;
import net.minecraft.screen.NamedScreenHandlerFactory;
import net.minecraft.screen.ScreenHandler;
import net.minecraft.screen.ScreenHandlerFactory;
import net.minecraft.screen.SimpleNamedScreenHandlerFactory;
import net.minecraft.server.network.ServerPlayNetworkHandler;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.util.Identifier;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ServerPlayerEntity.class})
public abstract class ServerPlayerEntityMixin
extends PlayerEntity {
    @Shadow
    private int field_13986;

    private ServerPlayerEntityMixin(World world, BlockPos pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Shadow
    public abstract void closeHandledScreen();

    @Redirect(method={"openHandledScreen(Lnet/minecraft/screen/NamedScreenHandlerFactory;)Ljava/util/OptionalInt;"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;closeHandledScreen()V"))
    private void fabric_closeHandledScreenIfAllowed(ServerPlayerEntity player, NamedScreenHandlerFactory factory) {
        if (factory.shouldCloseCurrentScreen()) {
            this.closeHandledScreen();
        } else {
            this.onHandledScreenClosed();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Inject(method={"openHandledScreen(Lnet/minecraft/screen/NamedScreenHandlerFactory;)Ljava/util/OptionalInt;"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayNetworkHandler;sendPacket(Lnet/minecraft/network/packet/Packet;)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void fabric_storeOpenedScreenHandler(NamedScreenHandlerFactory factory, CallbackInfoReturnable<OptionalInt> info, ScreenHandler handler) {
        block3: {
            block2: {
                if (factory instanceof ExtendedScreenHandlerFactory) break block2;
                if (!(factory instanceof SimpleNamedScreenHandlerFactory)) break block3;
                SimpleNamedScreenHandlerFactory simpleFactory = (SimpleNamedScreenHandlerFactory)factory;
                if (!(simpleFactory.baseFactory instanceof ExtendedScreenHandlerFactory)) break block3;
            }
            this.currentScreenHandler = handler;
            return;
        }
        if (!(handler.getType() instanceof ExtendedScreenHandlerType)) return;
        Identifier id = Registries.SCREEN_HANDLER.getId((Object)handler.getType());
        throw new IllegalArgumentException("[Fabric] Extended screen handler " + String.valueOf(id) + " must be opened with an ExtendedScreenHandlerFactory!");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Redirect(method={"openHandledScreen(Lnet/minecraft/screen/NamedScreenHandlerFactory;)Ljava/util/OptionalInt;"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayNetworkHandler;sendPacket(Lnet/minecraft/network/packet/Packet;)V"))
    private void fabric_replaceVanillaScreenPacket(ServerPlayNetworkHandler networkHandler, Packet<?> packet, NamedScreenHandlerFactory factory) {
        if (factory instanceof SimpleNamedScreenHandlerFactory) {
            SimpleNamedScreenHandlerFactory simpleFactory = (SimpleNamedScreenHandlerFactory)factory;
            ScreenHandlerFactory screenHandlerFactory = simpleFactory.baseFactory;
            if (screenHandlerFactory instanceof ExtendedScreenHandlerFactory) {
                ExtendedScreenHandlerFactory extendedFactory = (ExtendedScreenHandlerFactory)screenHandlerFactory;
                factory = extendedFactory;
            }
        }
        if (!(factory instanceof ExtendedScreenHandlerFactory)) {
            networkHandler.sendPacket(packet);
            return;
        }
        ExtendedScreenHandlerFactory extendedFactory = (ExtendedScreenHandlerFactory)factory;
        ScreenHandler handler = Objects.requireNonNull(this.currentScreenHandler);
        if (handler.getType() instanceof ExtendedScreenHandlerType) {
            Networking.sendOpenPacket((ServerPlayerEntity)this, extendedFactory, handler, this.field_13986);
            return;
        }
        Identifier id = Registries.SCREEN_HANDLER.getId((Object)handler.getType());
        throw new IllegalArgumentException("[Fabric] Non-extended screen handler " + String.valueOf(id) + " must not be opened with an ExtendedScreenHandlerFactory!");
    }
}

