/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.screenhandler;

import io.netty.buffer.Unpooled;
import java.util.Objects;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.registry.Registries;
import net.minecraft.screen.ScreenHandler;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.util.Identifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Networking {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-screen-handler-api-v1/server");
    public static final Identifier OPEN_ID = new Identifier("fabric-screen-handler-api-v1", "open_screen");

    public static void sendOpenPacket(ServerPlayerEntity player, ExtendedScreenHandlerFactory factory, ScreenHandler handler, int syncId) {
        Objects.requireNonNull(player, "player is null");
        Objects.requireNonNull(factory, "factory is null");
        Objects.requireNonNull(handler, "handler is null");
        Identifier typeId = Registries.SCREEN_HANDLER.getId((Object)handler.getType());
        if (typeId == null) {
            LOGGER.warn("Trying to open unregistered screen handler {}", (Object)handler);
            return;
        }
        PacketByteBuf buf = new PacketByteBuf(Unpooled.buffer());
        buf.writeIdentifier(typeId);
        buf.writeVarInt(syncId);
        buf.writeText(factory.getDisplayName());
        factory.writeScreenOpeningData(player, buf);
        ServerPlayNetworking.send((ServerPlayerEntity)player, (Identifier)OPEN_ID, (PacketByteBuf)buf);
    }
}

