/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.gamerule.widget;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.gamerule.v1.rule.EnumRule;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.gui.DrawContext;
import net.minecraft.client.gui.screen.world.EditGameRulesScreen;
import net.minecraft.client.gui.widget.ButtonWidget;
import net.minecraft.client.resource.language.I18n;
import net.minecraft.text.OrderedText;
import net.minecraft.text.StringVisitable;
import net.minecraft.text.Text;

@Environment(value=EnvType.CLIENT)
public final class EnumRuleWidget<E extends Enum<E>>
extends EditGameRulesScreen.NamedRuleWidget {
    private final ButtonWidget buttonWidget;
    private final String rootTranslationKey;

    public EnumRuleWidget(EditGameRulesScreen gameRuleScreen, Text name, List<OrderedText> description, String ruleName, EnumRule<E> rule, String translationKey) {
        EditGameRulesScreen editGameRulesScreen = gameRuleScreen;
        Objects.requireNonNull(editGameRulesScreen);
        super(editGameRulesScreen, description, name);
        this.name = MinecraftClient.getInstance().textRenderer.wrapLines((StringVisitable)name, 131);
        this.rootTranslationKey = translationKey;
        this.buttonWidget = ButtonWidget.builder((Text)this.getValueText(rule.get()), buttonWidget -> {
            rule.cycle();
            buttonWidget.setMessage(this.getValueText(rule.get()));
        }).position(10, 5).size(88, 20).build();
        this.children.add(this.buttonWidget);
    }

    public Text getValueText(E value) {
        String key = this.rootTranslationKey + "." + ((Enum)value).name().toLowerCase(Locale.ROOT);
        if (I18n.hasTranslation((String)key)) {
            return Text.translatable((String)key);
        }
        return Text.literal((String)((Enum)value).toString());
    }

    public void render(DrawContext drawContext, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        this.drawName(drawContext, y, x);
        this.buttonWidget.setPosition(x + entryWidth - 89, y);
        this.buttonWidget.render(drawContext, mouseX, mouseY, tickDelta);
    }
}

