/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.renderer.client;

import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.block.BlockState;
import net.minecraft.client.render.model.BakedModel;
import net.minecraft.client.render.model.WeightedBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.collection.Weighted;
import net.minecraft.util.collection.Weighting;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.random.Random;
import net.minecraft.world.BlockRenderView;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={WeightedBakedModel.class})
public class WeightedBakedModelMixin
implements FabricBakedModel {
    @Shadow
    @Final
    private int field_5433;
    @Shadow
    @Final
    private List<Weighted.Present<BakedModel>> field_5434;
    @Unique
    boolean isVanilla = true;

    @Inject(at={@At(value="RETURN")}, method={"<init>"})
    private void onInit(List<Weighted.Present<BakedModel>> models, CallbackInfo cb) {
        for (int i = 0; i < models.size(); ++i) {
            if (((BakedModel)models.get(i).getData()).isVanillaAdapter()) continue;
            this.isVanilla = false;
            break;
        }
    }

    @Override
    public boolean isVanillaAdapter() {
        return this.isVanilla;
    }

    @Override
    public void emitBlockQuads(BlockRenderView blockView, BlockState state, BlockPos pos, Supplier<Random> randomSupplier, RenderContext context) {
        Weighted.Present selected = Weighting.getAt(this.field_5434, (int)(Math.abs((int)randomSupplier.get().nextLong()) % this.field_5433)).orElse(null);
        if (selected != null) {
            ((BakedModel)selected.getData()).emitBlockQuads(blockView, state, pos, () -> {
                Random random = (Random)randomSupplier.get();
                random.nextLong();
                return random;
            }, context);
        }
    }

    @Override
    public void emitItemQuads(ItemStack stack, Supplier<Random> randomSupplier, RenderContext context) {
        Weighted.Present selected = Weighting.getAt(this.field_5434, (int)(Math.abs((int)randomSupplier.get().nextLong()) % this.field_5433)).orElse(null);
        if (selected != null) {
            ((BakedModel)selected.getData()).emitItemQuads(stack, () -> {
                Random random = (Random)randomSupplier.get();
                random.nextLong();
                return random;
            }, context);
        }
    }
}

