/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.renderer.v1.render;

import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.block.BlockState;
import net.minecraft.client.render.model.BakedModel;
import net.minecraft.client.render.model.json.ModelTransformationMode;
import net.minecraft.util.math.Direction;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public interface RenderContext {
    public QuadEmitter getEmitter();

    default public boolean hasTransform() {
        return true;
    }

    public void pushTransform(QuadTransform var1);

    public void popTransform();

    default public boolean isFaceCulled(@Nullable Direction face) {
        return false;
    }

    default public ModelTransformationMode itemTransformationMode() {
        return ModelTransformationMode.NONE;
    }

    @Deprecated
    default public Consumer<Mesh> meshConsumer() {
        return mesh -> mesh.outputTo(this.getEmitter());
    }

    @Deprecated(forRemoval=true)
    public BakedModelConsumer bakedModelConsumer();

    @Deprecated(forRemoval=true)
    default public Consumer<BakedModel> fallbackConsumer() {
        return this.bakedModelConsumer();
    }

    @Deprecated(forRemoval=true)
    @Environment(value=EnvType.CLIENT)
    public static interface BakedModelConsumer
    extends Consumer<BakedModel> {
        @Override
        public void accept(BakedModel var1);

        public void accept(BakedModel var1, @Nullable BlockState var2);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface QuadTransform {
        public boolean transform(MutableQuadView var1);
    }
}

