/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.renderer.v1.model;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.renderer.v1.model.SpriteFinder;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.render.model.BakedQuad;
import net.minecraft.client.render.model.json.ModelTransformation;
import net.minecraft.client.render.model.json.Transformation;
import net.minecraft.client.texture.SpriteAtlasTexture;
import net.minecraft.util.math.Direction;
import net.minecraft.util.math.MathHelper;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public final class ModelHelper {
    public static final int NULL_FACE_ID = 6;
    private static final Direction[] FACES = Arrays.copyOf(Direction.values(), 7);
    public static final Transformation TRANSFORM_BLOCK_GUI = ModelHelper.makeTransform(30.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.625f, 0.625f, 0.625f);
    public static final Transformation TRANSFORM_BLOCK_GROUND = ModelHelper.makeTransform(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
    public static final Transformation TRANSFORM_BLOCK_FIXED = ModelHelper.makeTransform(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
    public static final Transformation TRANSFORM_BLOCK_3RD_PERSON_RIGHT = ModelHelper.makeTransform(75.0f, 45.0f, 0.0f, 0.0f, 2.5f, 0.0f, 0.375f, 0.375f, 0.375f);
    public static final Transformation TRANSFORM_BLOCK_1ST_PERSON_RIGHT = ModelHelper.makeTransform(0.0f, 45.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
    public static final Transformation TRANSFORM_BLOCK_1ST_PERSON_LEFT = ModelHelper.makeTransform(0.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
    public static final ModelTransformation MODEL_TRANSFORM_BLOCK = new ModelTransformation(TRANSFORM_BLOCK_3RD_PERSON_RIGHT, TRANSFORM_BLOCK_3RD_PERSON_RIGHT, TRANSFORM_BLOCK_1ST_PERSON_LEFT, TRANSFORM_BLOCK_1ST_PERSON_RIGHT, Transformation.IDENTITY, TRANSFORM_BLOCK_GUI, TRANSFORM_BLOCK_GROUND, TRANSFORM_BLOCK_FIXED);

    private ModelHelper() {
    }

    public static int toFaceIndex(Direction face) {
        return face == null ? 6 : face.getId();
    }

    public static Direction faceFromIndex(int faceIndex) {
        return FACES[faceIndex];
    }

    public static List<BakedQuad>[] toQuadLists(Mesh mesh) {
        SpriteFinder finder = SpriteFinder.get(MinecraftClient.getInstance().getBakedModelManager().getAtlas(SpriteAtlasTexture.BLOCK_ATLAS_TEXTURE));
        ImmutableList.Builder[] builders = new ImmutableList.Builder[7];
        for (int i = 0; i < 7; ++i) {
            builders[i] = ImmutableList.builder();
        }
        if (mesh != null) {
            mesh.forEach(q -> {
                Direction cullFace = q.cullFace();
                builders[cullFace == null ? 6 : cullFace.getId()].add((Object)q.toBakedQuad(finder.find((QuadView)q)));
            });
        }
        List[] result = new List[7];
        for (int i = 0; i < 7; ++i) {
            result[i] = builders[i].build();
        }
        return result;
    }

    private static Transformation makeTransform(float rotationX, float rotationY, float rotationZ, float translationX, float translationY, float translationZ, float scaleX, float scaleY, float scaleZ) {
        Vector3f translation = new Vector3f(translationX, translationY, translationZ);
        translation.mul(0.0625f);
        translation.set(MathHelper.clamp((float)translation.x, (float)-5.0f, (float)5.0f), MathHelper.clamp((float)translation.y, (float)-5.0f, (float)5.0f), MathHelper.clamp((float)translation.z, (float)-5.0f, (float)5.0f));
        return new Transformation(new Vector3f(rotationX, rotationY, rotationZ), translation, new Vector3f(scaleX, scaleY, scaleZ));
    }
}

