/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.renderer.v1.mesh;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.client.render.model.BakedQuad;
import net.minecraft.client.texture.Sprite;
import net.minecraft.util.math.Direction;
import net.minecraft.util.math.Vec2f;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public interface QuadEmitter
extends MutableQuadView {
    public static final float CULL_FACE_EPSILON = 1.0E-5f;

    @Override
    public QuadEmitter pos(int var1, float var2, float var3, float var4);

    @Override
    default public QuadEmitter pos(int vertexIndex, Vector3f pos) {
        MutableQuadView.super.pos(vertexIndex, pos);
        return this;
    }

    @Override
    public QuadEmitter color(int var1, int var2);

    @Override
    default public QuadEmitter color(int c0, int c1, int c2, int c3) {
        MutableQuadView.super.color(c0, c1, c2, c3);
        return this;
    }

    @Override
    public QuadEmitter uv(int var1, float var2, float var3);

    @Override
    default public QuadEmitter uv(int vertexIndex, Vector2f uv) {
        MutableQuadView.super.uv(vertexIndex, uv);
        return this;
    }

    @Override
    public QuadEmitter spriteBake(Sprite var1, int var2);

    default public QuadEmitter uvUnitSquare() {
        this.uv(0, 0.0f, 0.0f);
        this.uv(1, 0.0f, 1.0f);
        this.uv(2, 1.0f, 1.0f);
        this.uv(3, 1.0f, 0.0f);
        return this;
    }

    @Override
    public QuadEmitter lightmap(int var1, int var2);

    @Override
    default public QuadEmitter lightmap(int b0, int b1, int b2, int b3) {
        MutableQuadView.super.lightmap(b0, b1, b2, b3);
        return this;
    }

    @Override
    public QuadEmitter normal(int var1, float var2, float var3, float var4);

    @Override
    default public QuadEmitter normal(int vertexIndex, Vector3f normal) {
        MutableQuadView.super.normal(vertexIndex, normal);
        return this;
    }

    @Override
    public QuadEmitter cullFace(@Nullable Direction var1);

    @Override
    public QuadEmitter nominalFace(@Nullable Direction var1);

    @Override
    public QuadEmitter material(RenderMaterial var1);

    @Override
    public QuadEmitter colorIndex(int var1);

    @Override
    public QuadEmitter tag(int var1);

    @Override
    public QuadEmitter copyFrom(QuadView var1);

    @Override
    public QuadEmitter fromVanilla(int[] var1, int var2);

    @Override
    public QuadEmitter fromVanilla(BakedQuad var1, RenderMaterial var2, @Nullable Direction var3);

    default public QuadEmitter square(Direction nominalFace, float left, float bottom, float right, float top, float depth) {
        if (Math.abs(depth) < 1.0E-5f) {
            this.cullFace(nominalFace);
            depth = 0.0f;
        } else {
            this.cullFace(null);
        }
        this.nominalFace(nominalFace);
        switch (nominalFace) {
            case UP: {
                depth = 1.0f - depth;
                top = 1.0f - top;
                bottom = 1.0f - bottom;
            }
            case DOWN: {
                this.pos(0, left, depth, top);
                this.pos(1, left, depth, bottom);
                this.pos(2, right, depth, bottom);
                this.pos(3, right, depth, top);
                break;
            }
            case EAST: {
                depth = 1.0f - depth;
                left = 1.0f - left;
                right = 1.0f - right;
            }
            case WEST: {
                this.pos(0, depth, top, left);
                this.pos(1, depth, bottom, left);
                this.pos(2, depth, bottom, right);
                this.pos(3, depth, top, right);
                break;
            }
            case SOUTH: {
                depth = 1.0f - depth;
                left = 1.0f - left;
                right = 1.0f - right;
            }
            case NORTH: {
                this.pos(0, 1.0f - left, top, depth);
                this.pos(1, 1.0f - left, bottom, depth);
                this.pos(2, 1.0f - right, bottom, depth);
                this.pos(3, 1.0f - right, top, depth);
            }
        }
        return this;
    }

    public QuadEmitter emit();

    @Override
    @Deprecated
    default public QuadEmitter spriteColor(int vertexIndex, int spriteIndex, int color) {
        MutableQuadView.super.spriteColor(vertexIndex, spriteIndex, color);
        return this;
    }

    @Override
    @Deprecated
    default public QuadEmitter spriteColor(int spriteIndex, int c0, int c1, int c2, int c3) {
        MutableQuadView.super.spriteColor(spriteIndex, c0, c1, c2, c3);
        return this;
    }

    @Override
    @Deprecated
    default public QuadEmitter sprite(int vertexIndex, int spriteIndex, float u, float v) {
        MutableQuadView.super.sprite(vertexIndex, spriteIndex, u, v);
        return this;
    }

    @Override
    @Deprecated
    default public QuadEmitter sprite(int vertexIndex, int spriteIndex, Vec2f uv) {
        MutableQuadView.super.sprite(vertexIndex, spriteIndex, uv);
        return this;
    }

    @Override
    @Deprecated
    default public QuadEmitter spriteBake(int spriteIndex, Sprite sprite, int bakeFlags) {
        MutableQuadView.super.spriteBake(spriteIndex, sprite, bakeFlags);
        return this;
    }

    @Deprecated
    default public QuadEmitter spriteUnitSquare(int spriteIndex) {
        this.uvUnitSquare();
        return this;
    }

    @Override
    @Deprecated
    default public QuadEmitter fromVanilla(int[] quadData, int startIndex, boolean isItem) {
        MutableQuadView.super.fromVanilla(quadData, startIndex, isItem);
        return this;
    }
}

