/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.transfer.item;

import com.google.common.collect.MapMaker;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.item.base.SingleStackStorage;
import net.minecraft.item.ItemStack;
import net.minecraft.registry.Registries;
import net.minecraft.screen.ScreenHandler;

public class CursorSlotWrapper
extends SingleStackStorage {
    private static final Map<ScreenHandler, CursorSlotWrapper> WRAPPERS = new MapMaker().weakValues().makeMap();
    private final ScreenHandler screenHandler;

    public static CursorSlotWrapper get(ScreenHandler screenHandler) {
        return WRAPPERS.computeIfAbsent(screenHandler, CursorSlotWrapper::new);
    }

    private CursorSlotWrapper(ScreenHandler screenHandler) {
        this.screenHandler = screenHandler;
    }

    @Override
    protected ItemStack getStack() {
        return this.screenHandler.getCursorStack();
    }

    @Override
    protected void setStack(ItemStack stack) {
        this.screenHandler.setCursorStack(stack);
    }

    @Override
    public String toString() {
        return "CursorSlotWrapper[" + String.valueOf(this.screenHandler) + "/" + String.valueOf(Registries.SCREEN_HANDLER.getId((Object)this.screenHandler.getType())) + "]";
    }
}

