/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.transfer.v1.item;

import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.impl.transfer.item.CursorSlotWrapper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.screen.ScreenHandler;
import net.minecraft.util.Hand;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
@ApiStatus.NonExtendable
public interface PlayerInventoryStorage
extends InventoryStorage {
    public static PlayerInventoryStorage of(PlayerEntity player) {
        return PlayerInventoryStorage.of(player.getInventory());
    }

    public static PlayerInventoryStorage of(PlayerInventory playerInventory) {
        return (PlayerInventoryStorage)InventoryStorage.of((Inventory)playerInventory, null);
    }

    public static SingleSlotStorage<ItemVariant> getCursorStorage(ScreenHandler screenHandler) {
        return CursorSlotWrapper.get(screenHandler);
    }

    @Override
    public long insert(ItemVariant var1, long var2, TransactionContext var4);

    default public void offerOrDrop(ItemVariant variant, long amount, TransactionContext transaction) {
        long offered = this.offer(variant, amount, transaction);
        this.drop(variant, amount - offered, transaction);
    }

    public long offer(ItemVariant var1, long var2, TransactionContext var4);

    public void drop(ItemVariant var1, long var2, boolean var4, boolean var5, TransactionContext var6);

    default public void drop(ItemVariant variant, long amount, boolean retainOwnership, TransactionContext transaction) {
        this.drop(variant, amount, false, retainOwnership, transaction);
    }

    default public void drop(ItemVariant variant, long amount, TransactionContext transaction) {
        this.drop(variant, amount, false, transaction);
    }

    public SingleSlotStorage<ItemVariant> getHandSlot(Hand var1);
}

