/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.transfer.item;

import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.fabricmc.fabric.impl.transfer.DebugMessages;
import net.fabricmc.fabric.impl.transfer.item.InventorySlotWrapper;
import net.fabricmc.fabric.impl.transfer.item.PlayerInventoryStorageImpl;
import net.fabricmc.fabric.impl.transfer.item.SidedInventoryStorageImpl;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.SidedInventory;
import net.minecraft.util.math.Direction;
import org.jetbrains.annotations.Nullable;

public class InventoryStorageImpl
extends CombinedStorage<ItemVariant, SingleSlotStorage<ItemVariant>>
implements InventoryStorage {
    private static final Map<Inventory, InventoryStorageImpl> WRAPPERS = new MapMaker().weakValues().makeMap();
    final Inventory inventory;
    final List<InventorySlotWrapper> backingList;
    final MarkDirtyParticipant markDirtyParticipant = new MarkDirtyParticipant();

    public static InventoryStorage of(Inventory inventory, @Nullable Direction direction) {
        InventoryStorageImpl storage = WRAPPERS.computeIfAbsent(inventory, inv -> {
            if (inv instanceof PlayerInventory) {
                PlayerInventory playerInventory = (PlayerInventory)inv;
                return new PlayerInventoryStorageImpl(playerInventory);
            }
            return new InventoryStorageImpl((Inventory)inv);
        });
        storage.resizeSlotList();
        return storage.getSidedWrapper(direction);
    }

    InventoryStorageImpl(Inventory inventory) {
        super(Collections.emptyList());
        this.inventory = inventory;
        this.backingList = new ArrayList<InventorySlotWrapper>();
    }

    @Override
    public List<SingleSlotStorage<ItemVariant>> getSlots() {
        return this.parts;
    }

    private void resizeSlotList() {
        int inventorySize = this.inventory.size();
        if (inventorySize != this.parts.size()) {
            while (this.backingList.size() < inventorySize) {
                this.backingList.add(new InventorySlotWrapper(this, this.backingList.size()));
            }
            this.parts = Collections.unmodifiableList(this.backingList.subList(0, inventorySize));
        }
    }

    private InventoryStorage getSidedWrapper(@Nullable Direction direction) {
        if (this.inventory instanceof SidedInventory && direction != null) {
            return new SidedInventoryStorageImpl(this, direction);
        }
        return this;
    }

    @Override
    public String toString() {
        return "InventoryStorage[" + DebugMessages.forInventory(this.inventory) + "]";
    }

    class MarkDirtyParticipant
    extends SnapshotParticipant<Boolean> {
        MarkDirtyParticipant() {
        }

        @Override
        protected Boolean createSnapshot() {
            return Boolean.TRUE;
        }

        @Override
        protected void readSnapshot(Boolean snapshot) {
        }

        @Override
        protected void onFinalCommit() {
            InventoryStorageImpl.this.inventory.markDirty();
        }
    }
}

