/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.transfer.v1.fluid;

import java.util.Collection;
import java.util.Iterator;
import net.fabricmc.fabric.api.lookup.v1.custom.ApiProviderMap;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.impl.transfer.fluid.CauldronStorage;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeveledCauldronBlock;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.property.IntProperty;
import net.minecraft.state.property.Property;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class CauldronFluidContent {
    public final Block block;
    public final Fluid fluid;
    public final long amountPerLevel;
    public final int maxLevel;
    @Nullable
    public final IntProperty levelProperty;
    private static final ApiProviderMap<Block, CauldronFluidContent> BLOCK_TO_CAULDRON = ApiProviderMap.create();
    private static final ApiProviderMap<Fluid, CauldronFluidContent> FLUID_TO_CAULDRON = ApiProviderMap.create();

    private CauldronFluidContent(Block block, Fluid fluid, long amountPerLevel, int maxLevel, @Nullable IntProperty levelProperty) {
        this.block = block;
        this.fluid = fluid;
        this.amountPerLevel = amountPerLevel;
        this.maxLevel = maxLevel;
        this.levelProperty = levelProperty;
    }

    @Nullable
    public static CauldronFluidContent getForBlock(Block block) {
        return (CauldronFluidContent)BLOCK_TO_CAULDRON.get((Object)block);
    }

    @Nullable
    public static CauldronFluidContent getForFluid(Fluid fluid) {
        return (CauldronFluidContent)FLUID_TO_CAULDRON.get((Object)fluid);
    }

    public static synchronized CauldronFluidContent registerCauldron(Block block, Fluid fluid, long amountPerLevel, @Nullable IntProperty levelProperty) {
        CauldronFluidContent data;
        CauldronFluidContent existingBlockData = (CauldronFluidContent)BLOCK_TO_CAULDRON.get((Object)block);
        if (existingBlockData != null) {
            return existingBlockData;
        }
        if (FLUID_TO_CAULDRON.get((Object)fluid) != null) {
            throw new IllegalArgumentException("Fluid already has a mapping for a different block.");
        }
        if (levelProperty == null) {
            data = new CauldronFluidContent(block, fluid, amountPerLevel, 1, null);
        } else {
            Collection levels = levelProperty.getValues();
            if (levels.size() == 0) {
                throw new RuntimeException("Cauldron should have at least one possible level.");
            }
            int minLevel = Integer.MAX_VALUE;
            int maxLevel = 0;
            Iterator iterator = levels.iterator();
            while (iterator.hasNext()) {
                int level = (Integer)iterator.next();
                minLevel = Math.min(minLevel, level);
                maxLevel = Math.max(maxLevel, level);
            }
            if (minLevel != 1 || maxLevel < 1) {
                throw new IllegalStateException("Minimum level should be 1, and maximum level should be >= 1.");
            }
            data = new CauldronFluidContent(block, fluid, amountPerLevel, maxLevel, levelProperty);
        }
        BLOCK_TO_CAULDRON.putIfAbsent((Object)block, (Object)data);
        FLUID_TO_CAULDRON.putIfAbsent((Object)fluid, (Object)data);
        FluidStorage.SIDED.registerForBlocks((world, pos, state, be, context) -> CauldronStorage.get(world, pos), new Block[]{block});
        return data;
    }

    public int currentLevel(BlockState state) {
        if (this.fluid == Fluids.EMPTY) {
            return 0;
        }
        if (this.levelProperty == null) {
            return 1;
        }
        return (Integer)state.get((Property)this.levelProperty);
    }

    static {
        CauldronFluidContent.registerCauldron(Blocks.CAULDRON, Fluids.EMPTY, 81000L, null);
        CauldronFluidContent.registerCauldron(Blocks.WATER_CAULDRON, (Fluid)Fluids.WATER, 27000L, LeveledCauldronBlock.LEVEL);
        CauldronFluidContent.registerCauldron(Blocks.LAVA_CAULDRON, (Fluid)Fluids.LAVA, 81000L, null);
    }
}

