/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.registry.sync.trackers;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import java.util.Collection;
import java.util.function.Function;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.fabricmc.fabric.api.event.registry.RegistryIdRemapCallback;
import net.fabricmc.fabric.impl.registry.sync.RemovableIdList;
import net.minecraft.registry.Registry;
import net.minecraft.util.Identifier;
import net.minecraft.util.collection.IdList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StateIdTracker<T, S>
implements RegistryIdRemapCallback<T>,
RegistryEntryAddedCallback<T> {
    private final Logger logger = LoggerFactory.getLogger(StateIdTracker.class);
    private final Registry<T> registry;
    private final IdList<S> stateList;
    private final Function<T, Collection<S>> stateGetter;
    private int currentHighestId = 0;

    public static <T, S> void register(Registry<T> registry, IdList<S> stateList, Function<T, Collection<S>> stateGetter) {
        StateIdTracker<T, S> tracker = new StateIdTracker<T, S>(registry, stateList, stateGetter);
        RegistryEntryAddedCallback.event(registry).register(tracker);
        RegistryIdRemapCallback.event(registry).register(tracker);
    }

    private StateIdTracker(Registry<T> registry, IdList<S> stateList, Function<T, Collection<S>> stateGetter) {
        this.registry = registry;
        this.stateList = stateList;
        this.stateGetter = stateGetter;
        this.recalcHighestId();
    }

    @Override
    public void onEntryAdded(int rawId, Identifier id, T object) {
        if (rawId == this.currentHighestId + 1) {
            this.stateGetter.apply(object).forEach(arg_0 -> this.stateList.add(arg_0));
            this.currentHighestId = rawId;
        } else {
            this.logger.debug("[fabric-registry-sync] Non-sequential RegistryEntryAddedCallback for " + object.getClass().getSimpleName() + " ID tracker (at " + String.valueOf(id) + "), forcing state map recalculation...");
            this.recalcStateMap();
        }
    }

    @Override
    public void onRemap(RegistryIdRemapCallback.RemapState<T> state) {
        this.recalcStateMap();
    }

    private void recalcStateMap() {
        ((RemovableIdList)this.stateList).fabric_clear();
        Int2ObjectRBTreeMap sortedBlocks = new Int2ObjectRBTreeMap();
        this.currentHighestId = 0;
        this.registry.forEach(arg_0 -> this.lambda$recalcStateMap$0((Int2ObjectMap)sortedBlocks, arg_0));
        for (Object b : sortedBlocks.values()) {
            this.stateGetter.apply(b).forEach(arg_0 -> this.stateList.add(arg_0));
        }
    }

    private void recalcHighestId() {
        this.currentHighestId = 0;
        for (Object object : this.registry) {
            this.currentHighestId = Math.max(this.currentHighestId, this.registry.getRawId(object));
        }
    }

    private /* synthetic */ void lambda$recalcStateMap$0(Int2ObjectMap sortedBlocks, Object t) {
        int rawId = this.registry.getRawId(t);
        this.currentHighestId = Math.max(this.currentHighestId, rawId);
        sortedBlocks.put(rawId, t);
    }
}

