/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.registry.sync;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.fabricmc.fabric.api.event.registry.RegistryAttributeHolder;
import net.fabricmc.fabric.impl.registry.sync.RemapException;
import net.fabricmc.fabric.impl.registry.sync.RemappableRegistry;
import net.fabricmc.fabric.impl.registry.sync.packet.DirectRegistryPacketHandler;
import net.fabricmc.fabric.impl.registry.sync.packet.RegistryPacketHandler;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.registry.Registries;
import net.minecraft.registry.Registry;
import net.minecraft.registry.RegistryKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.text.MutableText;
import net.minecraft.text.Text;
import net.minecraft.util.Formatting;
import net.minecraft.util.Identifier;
import net.minecraft.util.thread.ThreadExecutor;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegistrySyncManager {
    public static final boolean DEBUG = Boolean.getBoolean("fabric.registry.debug");
    public static final RegistryPacketHandler DIRECT_PACKET_HANDLER = new DirectRegistryPacketHandler();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"FabricRegistrySync");
    private static final boolean DEBUG_WRITE_REGISTRY_DATA = Boolean.getBoolean("fabric.registry.debug.writeContentsAsCsv");
    public static boolean postBootstrap = false;

    private RegistrySyncManager() {
    }

    public static void sendPacket(MinecraftServer server, ServerPlayerEntity player) {
        if (!DEBUG && server.isHost(player.getGameProfile())) {
            return;
        }
        RegistrySyncManager.sendPacket(player, DIRECT_PACKET_HANDLER);
    }

    private static void sendPacket(ServerPlayerEntity player, RegistryPacketHandler handler) {
        Map<Identifier, Object2IntMap<Identifier>> map = RegistrySyncManager.createAndPopulateRegistryMap(true, null);
        if (map != null) {
            handler.sendPacket(player, map);
        }
    }

    public static void receivePacket(ThreadExecutor<?> executor, RegistryPacketHandler handler, PacketByteBuf buf, boolean accept, Consumer<Exception> errorHandler) {
        handler.receivePacket(buf);
        if (!handler.isPacketFinished()) {
            return;
        }
        if (DEBUG) {
            String handlerName = handler.getClass().getSimpleName();
            LOGGER.info("{} total packet: {}", (Object)handlerName, (Object)handler.getTotalPacketReceived());
            LOGGER.info("{} raw size: {}", (Object)handlerName, (Object)handler.getRawBufSize());
            LOGGER.info("{} deflated size: {}", (Object)handlerName, (Object)handler.getDeflatedBufSize());
        }
        Map<Identifier, Object2IntMap<Identifier>> map = handler.getSyncedRegistryMap();
        if (accept) {
            try {
                executor.submit(() -> {
                    if (map == null) {
                        errorHandler.accept(new RemapException("Received null map in sync packet!"));
                        return null;
                    }
                    try {
                        RegistrySyncManager.apply(map, RemappableRegistry.RemapMode.REMOTE);
                    }
                    catch (RemapException e) {
                        errorHandler.accept(e);
                    }
                    return null;
                }).get(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                errorHandler.accept(e);
            }
        }
    }

    @Nullable
    public static Map<Identifier, Object2IntMap<Identifier>> createAndPopulateRegistryMap(boolean isClientSync, @Nullable Map<Identifier, Object2IntMap<Identifier>> activeMap) {
        LinkedHashMap<Identifier, Object2IntMap<Identifier>> map = new LinkedHashMap<Identifier, Object2IntMap<Identifier>>();
        for (Identifier registryId : Registries.REGISTRIES.getIds()) {
            RegistryAttributeHolder attributeHolder;
            Registry registry = (Registry)Registries.REGISTRIES.get(registryId);
            if (DEBUG_WRITE_REGISTRY_DATA) {
                File location = new File(".fabric" + File.separatorChar + "debug" + File.separatorChar + "registry");
                boolean c = true;
                if (!location.exists() && !location.mkdirs()) {
                    LOGGER.warn("[fabric-registry-sync debug] Could not create " + location.getAbsolutePath() + " directory!");
                    c = false;
                }
                if (c && registry != null) {
                    File file = new File(location, registryId.toString().replace(':', '.').replace('/', '.') + ".csv");
                    try (FileOutputStream stream = new FileOutputStream(file);){
                        StringBuilder builder = new StringBuilder("Raw ID,String ID,Class Type\n");
                        for (Object o : registry) {
                            String classType = o == null ? "null" : o.getClass().getName();
                            Identifier id = registry.getId(o);
                            if (id == null) continue;
                            int rawId = registry.getRawId(o);
                            String stringId = id.toString();
                            builder.append("\"").append(rawId).append("\",\"").append(stringId).append("\",\"").append(classType).append("\"\n");
                        }
                        stream.write(builder.toString().getBytes(StandardCharsets.UTF_8));
                    }
                    catch (IOException e) {
                        LOGGER.warn("[fabric-registry-sync debug] Could not write to " + file.getAbsolutePath() + "!", (Throwable)e);
                    }
                }
            }
            Object2IntMap<Identifier> previousIdMap = null;
            if (activeMap != null && activeMap.containsKey(registryId)) {
                previousIdMap = activeMap.get(registryId);
            }
            if (!(attributeHolder = RegistryAttributeHolder.get(registry.getKey())).hasAttribute(isClientSync ? RegistryAttribute.SYNCED : RegistryAttribute.PERSISTED)) {
                LOGGER.debug("Not {} registry: {}", (Object)(isClientSync ? "syncing" : "saving"), (Object)registryId);
                continue;
            }
            if ((previousIdMap == null || isClientSync) && !attributeHolder.hasAttribute(RegistryAttribute.MODDED)) {
                LOGGER.debug("Skipping un-modded registry: " + String.valueOf(registryId));
                continue;
            }
            if (previousIdMap != null) {
                LOGGER.debug("Preserving previously modded registry: " + String.valueOf(registryId));
            }
            if (isClientSync) {
                LOGGER.debug("Syncing registry: " + String.valueOf(registryId));
            } else {
                LOGGER.debug("Saving registry: " + String.valueOf(registryId));
            }
            if (!(registry instanceof RemappableRegistry)) continue;
            Object2IntLinkedOpenHashMap idMap = new Object2IntLinkedOpenHashMap();
            IntOpenHashSet rawIdsFound = DEBUG ? new IntOpenHashSet() : null;
            for (Object o : registry) {
                Identifier id = registry.getId(o);
                if (id == null) continue;
                int rawId = registry.getRawId(o);
                if (DEBUG) {
                    if (registry.get(id) != o) {
                        LOGGER.error("[fabric-registry-sync] Inconsistency detected in " + String.valueOf(registryId) + ": object " + String.valueOf(o) + " -> string ID " + String.valueOf(id) + " -> object " + String.valueOf(registry.get(id)) + "!");
                    }
                    if (registry.get(rawId) != o) {
                        LOGGER.error("[fabric-registry-sync] Inconsistency detected in " + String.valueOf(registryId) + ": object " + String.valueOf(o) + " -> integer ID " + rawId + " -> object " + String.valueOf(registry.get(rawId)) + "!");
                    }
                    if (!rawIdsFound.add(rawId)) {
                        LOGGER.error("[fabric-registry-sync] Inconsistency detected in " + String.valueOf(registryId) + ": multiple objects hold the raw ID " + rawId + " (this one is " + String.valueOf(id) + ")");
                    }
                }
                idMap.put((Object)id, rawId);
            }
            if (!isClientSync && previousIdMap != null) {
                for (Identifier key : previousIdMap.keySet()) {
                    if (idMap.containsKey((Object)key)) continue;
                    LOGGER.debug("Saving orphaned registry entry: " + String.valueOf(key));
                    idMap.put((Object)key, previousIdMap.getInt((Object)key));
                }
            }
            map.put(registryId, (Object2IntMap<Identifier>)idMap);
        }
        if (!isClientSync && activeMap != null) {
            for (Identifier registryKey : activeMap.keySet()) {
                if (map.containsKey(registryKey)) continue;
                LOGGER.debug("Saving orphaned registry: " + String.valueOf(registryKey));
                map.put(registryKey, activeMap.get(registryKey));
            }
        }
        if (map.isEmpty()) {
            return null;
        }
        return map;
    }

    public static void apply(Map<Identifier, Object2IntMap<Identifier>> map, RemappableRegistry.RemapMode mode) throws RemapException {
        if (mode == RemappableRegistry.RemapMode.REMOTE) {
            RegistrySyncManager.checkRemoteRemap(map);
        }
        HashSet containedRegistries = Sets.newHashSet(map.keySet());
        for (Identifier registryId : Registries.REGISTRIES.getIds()) {
            if (!containedRegistries.remove(registryId)) continue;
            Object2IntMap<Identifier> registryMap = map.get(registryId);
            Registry registry = (Registry)Registries.REGISTRIES.get(registryId);
            RegistryAttributeHolder attributeHolder = RegistryAttributeHolder.get(registry.getKey());
            if (!attributeHolder.hasAttribute(RegistryAttribute.MODDED)) {
                LOGGER.debug("Not applying registry data to vanilla registry {}", (Object)registryId.toString());
                continue;
            }
            if (!(registry instanceof RemappableRegistry)) continue;
            Object2IntOpenHashMap idMap = new Object2IntOpenHashMap();
            for (Identifier key : registryMap.keySet()) {
                idMap.put((Object)key, registryMap.getInt((Object)key));
            }
            ((RemappableRegistry)registry).remap(registryId.toString(), (Object2IntMap<Identifier>)idMap, mode);
        }
        if (!containedRegistries.isEmpty()) {
            LOGGER.warn("[fabric-registry-sync] Could not find the following registries: " + Joiner.on((String)", ").join((Iterable)containedRegistries));
        }
    }

    @VisibleForTesting
    public static void checkRemoteRemap(Map<Identifier, Object2IntMap<Identifier>> map) throws RemapException {
        HashMap<Identifier, List> missingEntries = new HashMap<Identifier, List>();
        for (Map.Entry entry : Registries.REGISTRIES.getEntrySet()) {
            Registry registry = (Registry)entry.getValue();
            Identifier registryId = ((RegistryKey)entry.getKey()).getValue();
            Object2IntMap<Identifier> remoteRegistry = map.get(registryId);
            if (remoteRegistry == null) continue;
            for (Identifier remoteId : remoteRegistry.keySet()) {
                if (registry.containsId(remoteId)) continue;
                missingEntries.computeIfAbsent(registryId, i -> new ArrayList()).add(remoteId);
            }
        }
        if (missingEntries.isEmpty()) {
            return;
        }
        LOGGER.error("Received unknown remote registry entries from server");
        for (Map.Entry entry : missingEntries.entrySet()) {
            for (Identifier identifier : (List)entry.getValue()) {
                LOGGER.error("Registry entry ({}) is missing from local registry ({})", (Object)identifier, entry.getKey());
            }
        }
        MutableText text = Text.literal((String)"");
        int n = missingEntries.values().stream().mapToInt(List::size).sum();
        text = n == 1 ? text.append((Text)Text.translatable((String)"fabric-registry-sync-v0.unknown-remote.title.singular")) : text.append((Text)Text.translatable((String)"fabric-registry-sync-v0.unknown-remote.title.plural", (Object[])new Object[]{n}));
        text = text.append((Text)Text.translatable((String)"fabric-registry-sync-v0.unknown-remote.subtitle.1").formatted(Formatting.GREEN));
        text = text.append((Text)Text.translatable((String)"fabric-registry-sync-v0.unknown-remote.subtitle.2"));
        int toDisplay = 4;
        List<String> namespaces = missingEntries.values().stream().flatMap(Collection::stream).map(Identifier::getNamespace).distinct().sorted().toList();
        for (int i2 = 0; i2 < Math.min(namespaces.size(), 4); ++i2) {
            text = text.append((Text)Text.literal((String)namespaces.get(i2)).formatted(Formatting.YELLOW));
            text = text.append("\n");
        }
        if (namespaces.size() > 4) {
            text = text.append((Text)Text.translatable((String)"fabric-registry-sync-v0.unknown-remote.footer", (Object[])new Object[]{namespaces.size() - 4}));
        }
        throw new RemapException((Text)text);
    }

    public static void unmap() throws RemapException {
        for (Identifier registryId : Registries.REGISTRIES.getIds()) {
            Registry registry = (Registry)Registries.REGISTRIES.get(registryId);
            if (!(registry instanceof RemappableRegistry)) continue;
            ((RemappableRegistry)registry).unmap(registryId.toString());
        }
    }

    public static void bootstrapRegistries() {
        postBootstrap = true;
    }
}

