/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.structure;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Function;
import net.minecraft.registry.Registerable;
import net.minecraft.registry.RegistryEntryLookup;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.RegistryKeys;
import net.minecraft.registry.entry.RegistryEntry;
import net.minecraft.structure.pool.StructurePool;
import net.minecraft.structure.pool.StructurePoolElement;
import net.minecraft.structure.pool.StructurePools;
import net.minecraft.structure.processor.StructureProcessorList;
import net.minecraft.structure.processor.StructureProcessorLists;
import net.minecraft.world.gen.feature.PlacedFeature;
import net.minecraft.world.gen.feature.VillagePlacedFeatures;

public class TaigaVillageData {
    public static final RegistryKey<StructurePool> TOWN_CENTERS_KEY = StructurePools.of("village/taiga/town_centers");
    private static final RegistryKey<StructurePool> TERMINATORS_KEY = StructurePools.of("village/taiga/terminators");

    public static void bootstrap(Registerable<StructurePool> poolRegisterable) {
        RegistryEntryLookup<PlacedFeature> registryEntryLookup = poolRegisterable.getRegistryLookup(RegistryKeys.PLACED_FEATURE);
        RegistryEntry.Reference<PlacedFeature> registryEntry = registryEntryLookup.getOrThrow(VillagePlacedFeatures.SPRUCE);
        RegistryEntry.Reference<PlacedFeature> registryEntry2 = registryEntryLookup.getOrThrow(VillagePlacedFeatures.PINE);
        RegistryEntry.Reference<PlacedFeature> registryEntry3 = registryEntryLookup.getOrThrow(VillagePlacedFeatures.PILE_PUMPKIN);
        RegistryEntry.Reference<PlacedFeature> registryEntry4 = registryEntryLookup.getOrThrow(VillagePlacedFeatures.PATCH_TAIGA_GRASS);
        RegistryEntry.Reference<PlacedFeature> registryEntry5 = registryEntryLookup.getOrThrow(VillagePlacedFeatures.PATCH_BERRY_BUSH);
        RegistryEntryLookup<StructureProcessorList> registryEntryLookup2 = poolRegisterable.getRegistryLookup(RegistryKeys.PROCESSOR_LIST);
        RegistryEntry.Reference<StructureProcessorList> registryEntry6 = registryEntryLookup2.getOrThrow(StructureProcessorLists.MOSSIFY_10_PERCENT);
        RegistryEntry.Reference<StructureProcessorList> registryEntry7 = registryEntryLookup2.getOrThrow(StructureProcessorLists.ZOMBIE_TAIGA);
        RegistryEntry.Reference<StructureProcessorList> registryEntry8 = registryEntryLookup2.getOrThrow(StructureProcessorLists.STREET_SNOWY_OR_TAIGA);
        RegistryEntry.Reference<StructureProcessorList> registryEntry9 = registryEntryLookup2.getOrThrow(StructureProcessorLists.FARM_TAIGA);
        RegistryEntryLookup<StructurePool> registryEntryLookup3 = poolRegisterable.getRegistryLookup(RegistryKeys.TEMPLATE_POOL);
        RegistryEntry.Reference<StructurePool> registryEntry10 = registryEntryLookup3.getOrThrow(StructurePools.EMPTY);
        RegistryEntry.Reference<StructurePool> registryEntry11 = registryEntryLookup3.getOrThrow(TERMINATORS_KEY);
        poolRegisterable.register(TOWN_CENTERS_KEY, new StructurePool(registryEntry10, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/town_centers/taiga_meeting_point_1", registryEntry6), (Object)49), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/town_centers/taiga_meeting_point_2", registryEntry6), (Object)49), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/town_centers/taiga_meeting_point_1", registryEntry7), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/town_centers/taiga_meeting_point_2", registryEntry7), (Object)1)), StructurePool.Projection.RIGID));
        StructurePools.register(poolRegisterable, "village/taiga/streets", new StructurePool(registryEntry11, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/streets/corner_01", registryEntry8), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/streets/corner_02", registryEntry8), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/streets/corner_03", registryEntry8), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/streets/straight_01", registryEntry8), (Object)4), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/streets/straight_02", registryEntry8), (Object)4), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/streets/straight_03", registryEntry8), (Object)4), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/streets/straight_04", registryEntry8), (Object)7), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/streets/straight_05", registryEntry8), (Object)7), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/streets/straight_06", registryEntry8), (Object)4), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/streets/crossroad_01", registryEntry8), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/streets/crossroad_02", registryEntry8), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/streets/crossroad_03", registryEntry8), (Object)2), (Object[])new Pair[]{Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/streets/crossroad_04", registryEntry8), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/streets/crossroad_05", registryEntry8), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/streets/crossroad_06", registryEntry8), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/streets/turn_01", registryEntry8), (Object)3)}), StructurePool.Projection.TERRAIN_MATCHING));
        StructurePools.register(poolRegisterable, "village/taiga/zombie/streets", new StructurePool(registryEntry11, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/streets/corner_01", registryEntry8), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/streets/corner_02", registryEntry8), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/streets/corner_03", registryEntry8), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/streets/straight_01", registryEntry8), (Object)4), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/streets/straight_02", registryEntry8), (Object)4), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/streets/straight_03", registryEntry8), (Object)4), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/streets/straight_04", registryEntry8), (Object)7), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/streets/straight_05", registryEntry8), (Object)7), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/streets/straight_06", registryEntry8), (Object)4), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/streets/crossroad_01", registryEntry8), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/streets/crossroad_02", registryEntry8), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/streets/crossroad_03", registryEntry8), (Object)2), (Object[])new Pair[]{Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/streets/crossroad_04", registryEntry8), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/streets/crossroad_05", registryEntry8), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/streets/crossroad_06", registryEntry8), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/streets/turn_01", registryEntry8), (Object)3)}), StructurePool.Projection.TERRAIN_MATCHING));
        StructurePools.register(poolRegisterable, "village/taiga/houses", new StructurePool(registryEntry11, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_small_house_1", registryEntry6), (Object)4), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_small_house_2", registryEntry6), (Object)4), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_small_house_3", registryEntry6), (Object)4), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_small_house_4", registryEntry6), (Object)4), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_small_house_5", registryEntry6), (Object)4), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_medium_house_1", registryEntry6), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_medium_house_2", registryEntry6), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_medium_house_3", registryEntry6), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_medium_house_4", registryEntry6), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_butcher_shop_1", registryEntry6), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_tool_smith_1", registryEntry6), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_fletcher_house_1", registryEntry6), (Object)2), (Object[])new Pair[]{Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_shepherds_house_1", registryEntry6), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_armorer_house_1", registryEntry6), (Object)1), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_armorer_2", registryEntry6), (Object)1), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_fisher_cottage_1", registryEntry6), (Object)3), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_tannery_1", registryEntry6), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_cartographer_house_1", registryEntry6), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_library_1", registryEntry6), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_masons_house_1", registryEntry6), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_weaponsmith_1", registryEntry6), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_weaponsmith_2", registryEntry6), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_temple_1", registryEntry6), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_large_farm_1", registryEntry9), (Object)6), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_large_farm_2", registryEntry9), (Object)6), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_small_farm_1", registryEntry6), (Object)1), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_animal_pen_1", registryEntry6), (Object)2), Pair.of(StructurePoolElement.ofEmpty(), (Object)6)}), StructurePool.Projection.RIGID));
        StructurePools.register(poolRegisterable, "village/taiga/zombie/houses", new StructurePool(registryEntry11, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/houses/taiga_small_house_1", registryEntry7), (Object)4), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/houses/taiga_small_house_2", registryEntry7), (Object)4), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/houses/taiga_small_house_3", registryEntry7), (Object)4), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/houses/taiga_small_house_4", registryEntry7), (Object)4), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/houses/taiga_small_house_5", registryEntry7), (Object)4), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/houses/taiga_medium_house_1", registryEntry7), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/houses/taiga_medium_house_2", registryEntry7), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/houses/taiga_medium_house_3", registryEntry7), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/houses/taiga_medium_house_4", registryEntry7), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_butcher_shop_1", registryEntry7), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/houses/taiga_tool_smith_1", registryEntry7), (Object)2), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_fletcher_house_1", registryEntry7), (Object)2), (Object[])new Pair[]{Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/houses/taiga_shepherds_house_1", registryEntry7), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_armorer_house_1", registryEntry7), (Object)1), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/houses/taiga_fisher_cottage_1", registryEntry7), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_tannery_1", registryEntry7), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/houses/taiga_cartographer_house_1", registryEntry7), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/houses/taiga_library_1", registryEntry7), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_masons_house_1", registryEntry7), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_weaponsmith_1", registryEntry7), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/houses/taiga_weaponsmith_2", registryEntry7), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/houses/taiga_temple_1", registryEntry7), (Object)2), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_large_farm_1", registryEntry7), (Object)6), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/zombie/houses/taiga_large_farm_2", registryEntry7), (Object)6), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_small_farm_1", registryEntry7), (Object)1), Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/taiga/houses/taiga_animal_pen_1", registryEntry7), (Object)2), Pair.of(StructurePoolElement.ofEmpty(), (Object)6)}), StructurePool.Projection.RIGID));
        poolRegisterable.register(TERMINATORS_KEY, new StructurePool(registryEntry10, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/plains/terminators/terminator_01", registryEntry8), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/plains/terminators/terminator_02", registryEntry8), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/plains/terminators/terminator_03", registryEntry8), (Object)1), (Object)Pair.of(StructurePoolElement.ofProcessedLegacySingle("village/plains/terminators/terminator_04", registryEntry8), (Object)1)), StructurePool.Projection.TERRAIN_MATCHING));
        StructurePools.register(poolRegisterable, "village/taiga/decor", new StructurePool(registryEntry10, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofLegacySingle("village/taiga/taiga_lamp_post_1"), (Object)10), (Object)Pair.of(StructurePoolElement.ofLegacySingle("village/taiga/taiga_decoration_1"), (Object)4), (Object)Pair.of(StructurePoolElement.ofLegacySingle("village/taiga/taiga_decoration_2"), (Object)1), (Object)Pair.of(StructurePoolElement.ofLegacySingle("village/taiga/taiga_decoration_3"), (Object)1), (Object)Pair.of(StructurePoolElement.ofLegacySingle("village/taiga/taiga_decoration_4"), (Object)1), (Object)Pair.of(StructurePoolElement.ofLegacySingle("village/taiga/taiga_decoration_5"), (Object)2), (Object)Pair.of(StructurePoolElement.ofLegacySingle("village/taiga/taiga_decoration_6"), (Object)1), (Object)Pair.of(StructurePoolElement.ofFeature(registryEntry), (Object)4), (Object)Pair.of(StructurePoolElement.ofFeature(registryEntry2), (Object)4), (Object)Pair.of(StructurePoolElement.ofFeature(registryEntry3), (Object)2), (Object)Pair.of(StructurePoolElement.ofFeature(registryEntry4), (Object)4), (Object)Pair.of(StructurePoolElement.ofFeature(registryEntry5), (Object)1), (Object[])new Pair[]{Pair.of(StructurePoolElement.ofEmpty(), (Object)4)}), StructurePool.Projection.RIGID));
        StructurePools.register(poolRegisterable, "village/taiga/zombie/decor", new StructurePool(registryEntry10, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofLegacySingle("village/taiga/taiga_decoration_1"), (Object)4), (Object)Pair.of(StructurePoolElement.ofLegacySingle("village/taiga/taiga_decoration_2"), (Object)1), (Object)Pair.of(StructurePoolElement.ofLegacySingle("village/taiga/taiga_decoration_3"), (Object)1), (Object)Pair.of(StructurePoolElement.ofLegacySingle("village/taiga/taiga_decoration_4"), (Object)1), (Object)Pair.of(StructurePoolElement.ofFeature(registryEntry), (Object)4), (Object)Pair.of(StructurePoolElement.ofFeature(registryEntry2), (Object)4), (Object)Pair.of(StructurePoolElement.ofFeature(registryEntry3), (Object)2), (Object)Pair.of(StructurePoolElement.ofFeature(registryEntry4), (Object)4), (Object)Pair.of(StructurePoolElement.ofFeature(registryEntry5), (Object)1), (Object)Pair.of(StructurePoolElement.ofEmpty(), (Object)4)), StructurePool.Projection.RIGID));
        StructurePools.register(poolRegisterable, "village/taiga/villagers", new StructurePool(registryEntry10, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofLegacySingle("village/taiga/villagers/nitwit"), (Object)1), (Object)Pair.of(StructurePoolElement.ofLegacySingle("village/taiga/villagers/baby"), (Object)1), (Object)Pair.of(StructurePoolElement.ofLegacySingle("village/taiga/villagers/unemployed"), (Object)10)), StructurePool.Projection.RIGID));
        StructurePools.register(poolRegisterable, "village/taiga/zombie/villagers", new StructurePool(registryEntry10, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofLegacySingle("village/taiga/zombie/villagers/nitwit"), (Object)1), (Object)Pair.of(StructurePoolElement.ofLegacySingle("village/taiga/zombie/villagers/unemployed"), (Object)10)), StructurePool.Projection.RIGID));
    }
}

