/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.structure;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Function;
import net.minecraft.registry.Registerable;
import net.minecraft.registry.RegistryEntryLookup;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.RegistryKeys;
import net.minecraft.registry.entry.RegistryEntry;
import net.minecraft.structure.pool.StructurePool;
import net.minecraft.structure.pool.StructurePoolElement;
import net.minecraft.structure.pool.StructurePools;
import net.minecraft.structure.processor.StructureProcessorList;
import net.minecraft.structure.processor.StructureProcessorLists;

public class PillagerOutpostGenerator {
    public static final RegistryKey<StructurePool> STRUCTURE_POOLS = StructurePools.of("pillager_outpost/base_plates");

    public static void bootstrap(Registerable<StructurePool> poolRegisterable) {
        RegistryEntryLookup<StructureProcessorList> registryEntryLookup = poolRegisterable.getRegistryLookup(RegistryKeys.PROCESSOR_LIST);
        RegistryEntry.Reference<StructureProcessorList> registryEntry = registryEntryLookup.getOrThrow(StructureProcessorLists.OUTPOST_ROT);
        RegistryEntryLookup<StructurePool> registryEntryLookup2 = poolRegisterable.getRegistryLookup(RegistryKeys.TEMPLATE_POOL);
        RegistryEntry.Reference<StructurePool> registryEntry2 = registryEntryLookup2.getOrThrow(StructurePools.EMPTY);
        poolRegisterable.register(STRUCTURE_POOLS, new StructurePool(registryEntry2, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofLegacySingle("pillager_outpost/base_plate"), (Object)1)), StructurePool.Projection.RIGID));
        StructurePools.register(poolRegisterable, "pillager_outpost/towers", new StructurePool(registryEntry2, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofList((List<Function<StructurePool.Projection, ? extends StructurePoolElement>>)ImmutableList.of(StructurePoolElement.ofLegacySingle("pillager_outpost/watchtower"), StructurePoolElement.ofProcessedLegacySingle("pillager_outpost/watchtower_overgrown", registryEntry))), (Object)1)), StructurePool.Projection.RIGID));
        StructurePools.register(poolRegisterable, "pillager_outpost/feature_plates", new StructurePool(registryEntry2, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofLegacySingle("pillager_outpost/feature_plate"), (Object)1)), StructurePool.Projection.TERRAIN_MATCHING));
        StructurePools.register(poolRegisterable, "pillager_outpost/features", new StructurePool(registryEntry2, (List<Pair<Function<StructurePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.ofLegacySingle("pillager_outpost/feature_cage1"), (Object)1), (Object)Pair.of(StructurePoolElement.ofLegacySingle("pillager_outpost/feature_cage2"), (Object)1), (Object)Pair.of(StructurePoolElement.ofLegacySingle("pillager_outpost/feature_cage_with_allays"), (Object)1), (Object)Pair.of(StructurePoolElement.ofLegacySingle("pillager_outpost/feature_logs"), (Object)1), (Object)Pair.of(StructurePoolElement.ofLegacySingle("pillager_outpost/feature_tent1"), (Object)1), (Object)Pair.of(StructurePoolElement.ofLegacySingle("pillager_outpost/feature_tent2"), (Object)1), (Object)Pair.of(StructurePoolElement.ofLegacySingle("pillager_outpost/feature_targets"), (Object)1), (Object)Pair.of(StructurePoolElement.ofEmpty(), (Object)6)), StructurePool.Projection.RIGID));
    }
}

