/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.mojang.authlib.GameProfile;
import net.minecraft.block.Block;
import net.minecraft.block.entity.SkullBlockEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.VerticallyAttachableBlockItem;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.nbt.NbtHelper;
import net.minecraft.text.Text;
import net.minecraft.util.Util;
import net.minecraft.util.math.Direction;

public class SkullItem
extends VerticallyAttachableBlockItem {
    public static final String SKULL_OWNER_KEY = "SkullOwner";

    public SkullItem(Block block, Block wallBlock, Item.Settings settings) {
        super(block, wallBlock, settings, Direction.DOWN);
    }

    @Override
    public Text getName(ItemStack stack) {
        if (stack.isOf(Items.PLAYER_HEAD) && stack.hasNbt()) {
            NbtCompound nbtCompound2;
            String string = null;
            NbtCompound nbtCompound = stack.getNbt();
            if (nbtCompound.contains(SKULL_OWNER_KEY, 8)) {
                string = nbtCompound.getString(SKULL_OWNER_KEY);
            } else if (nbtCompound.contains(SKULL_OWNER_KEY, 10) && (nbtCompound2 = nbtCompound.getCompound(SKULL_OWNER_KEY)).contains("Name", 8)) {
                string = nbtCompound2.getString("Name");
            }
            if (string != null) {
                return Text.translatable(this.getTranslationKey() + ".named", string);
            }
        }
        return super.getName(stack);
    }

    @Override
    public void postProcessNbt(NbtCompound nbt) {
        super.postProcessNbt(nbt);
        if (nbt.contains(SKULL_OWNER_KEY, 8) && !Util.isBlank(nbt.getString(SKULL_OWNER_KEY))) {
            GameProfile gameProfile = new GameProfile(null, nbt.getString(SKULL_OWNER_KEY));
            SkullBlockEntity.loadProperties(gameProfile, profile -> nbt.put(SKULL_OWNER_KEY, NbtHelper.writeGameProfile(new NbtCompound(), profile)));
        }
    }
}

