/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.client.rendering.fluid;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.impl.client.rendering.fluid.FluidRenderHandlerRegistryImpl;
import net.fabricmc.fabric.impl.client.rendering.fluid.FluidRendererHookContainer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.render.VertexConsumer;
import net.minecraft.client.render.block.FluidRenderer;
import net.minecraft.client.texture.Sprite;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.BlockRenderView;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={FluidRenderer.class})
public class FluidRendererMixin {
    @Final
    @Shadow
    private Sprite[] field_4165;
    @Final
    @Shadow
    private Sprite[] field_4166;
    @Shadow
    private Sprite field_4164;
    private final ThreadLocal<FluidRendererHookContainer> fabric_renderHandler = ThreadLocal.withInitial(FluidRendererHookContainer::new);
    private final ThreadLocal<Boolean> fabric_customRendering = ThreadLocal.withInitial(() -> false);
    private final ThreadLocal<Block> fabric_neighborBlock = new ThreadLocal();

    @Inject(at={@At(value="RETURN")}, method={"onResourceReload"})
    public void onResourceReloadReturn(CallbackInfo info) {
        FluidRenderer self = (FluidRenderer)this;
        ((FluidRenderHandlerRegistryImpl)FluidRenderHandlerRegistry.INSTANCE).onFluidRendererReload(self, this.field_4166, this.field_4165, this.field_4164);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(at={@At(value="HEAD")}, method={"render"}, cancellable=true)
    public void tesselate(BlockRenderView view, BlockPos pos, VertexConsumer vertexConsumer, BlockState blockState, FluidState fluidState, CallbackInfo info) {
        if (!this.fabric_customRendering.get().booleanValue()) {
            try {
                this.fabric_customRendering.set(true);
                this.tessellateViaHandler(view, pos, vertexConsumer, blockState, fluidState, info);
            }
            finally {
                this.fabric_customRendering.set(false);
            }
        }
        if (info.isCancelled()) {
            return;
        }
        FluidRendererHookContainer ctr = this.fabric_renderHandler.get();
        ctr.getSprites(view, pos, fluidState);
    }

    @Unique
    private void tessellateViaHandler(BlockRenderView view, BlockPos pos, VertexConsumer vertexConsumer, BlockState blockState, FluidState fluidState, CallbackInfo info) {
        FluidRendererHookContainer ctr = this.fabric_renderHandler.get();
        FluidRenderHandler handler = ((FluidRenderHandlerRegistryImpl)FluidRenderHandlerRegistry.INSTANCE).getOverride(fluidState.getFluid());
        ctr.view = view;
        ctr.pos = pos;
        ctr.blockState = blockState;
        ctr.fluidState = fluidState;
        ctr.handler = handler;
        if (handler != null) {
            handler.renderFluid(pos, view, vertexConsumer, blockState, fluidState);
            info.cancel();
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"render"})
    public void tesselateReturn(BlockRenderView world, BlockPos pos, VertexConsumer vertexConsumer, BlockState blockState, FluidState fluidState, CallbackInfo ci) {
        this.fabric_renderHandler.get().clear();
    }

    @ModifyVariable(at=@At(value="INVOKE", target="Lnet/minecraft/client/render/block/FluidRenderer;isSameFluid(Lnet/minecraft/fluid/FluidState;Lnet/minecraft/fluid/FluidState;)Z"), method={"render"}, ordinal=0)
    public boolean modLavaCheck(boolean chk) {
        FluidRendererHookContainer ctr = this.fabric_renderHandler.get();
        return !ctr.hasOverlay;
    }

    @ModifyVariable(at=@At(value="INVOKE", target="Lnet/minecraft/client/render/block/FluidRenderer;isSameFluid(Lnet/minecraft/fluid/FluidState;Lnet/minecraft/fluid/FluidState;)Z"), method={"render"}, ordinal=0)
    public Sprite[] modSpriteArray(Sprite[] chk) {
        FluidRendererHookContainer ctr = this.fabric_renderHandler.get();
        return ctr.handler != null ? ctr.sprites : chk;
    }

    @Redirect(at=@At(value="FIELD", opcode=180, target="Lnet/minecraft/client/render/block/FluidRenderer;waterOverlaySprite:Lnet/minecraft/client/texture/Sprite;"), method={"render"})
    public Sprite modWaterOverlaySprite(FluidRenderer self) {
        FluidRendererHookContainer ctr = this.fabric_renderHandler.get();
        return ctr.handler != null && ctr.hasOverlay ? ctr.overlay : this.field_4164;
    }

    @ModifyVariable(at=@At(value="CONSTANT", args={"intValue=16"}, ordinal=0, shift=At.Shift.BEFORE), method={"render"}, ordinal=0)
    public int modTintColor(int chk) {
        FluidRendererHookContainer ctr = this.fabric_renderHandler.get();
        return ctr.handler != null ? ctr.handler.getFluidColor(ctr.view, ctr.pos, ctr.fluidState) : chk;
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/block/BlockState;getBlock()Lnet/minecraft/block/Block;"), method={"render"})
    public Block getOverlayBlock(BlockState state) {
        Block block = state.getBlock();
        this.fabric_neighborBlock.set(block);
        return null;
    }

    @ModifyVariable(at=@At(value="INVOKE", target="Lnet/minecraft/block/BlockState;getBlock()Lnet/minecraft/block/Block;", shift=At.Shift.BY, by=2), method={"render"}, ordinal=0)
    public Sprite modSideSpriteForOverlay(Sprite chk) {
        Block block = this.fabric_neighborBlock.get();
        if (FluidRenderHandlerRegistry.INSTANCE.isBlockTransparent(block)) {
            FluidRendererHookContainer ctr = this.fabric_renderHandler.get();
            return ctr.handler != null && ctr.hasOverlay ? ctr.overlay : this.field_4164;
        }
        return chk;
    }
}

