/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.itemgroup;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.fabric.impl.itemgroup.FabricItemGroup;
import net.fabricmc.fabric.mixin.itemgroup.ItemGroupAccessor;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemGroups;
import net.minecraft.registry.Registries;
import net.minecraft.registry.RegistryKey;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemGroups.class})
public class ItemGroupsMixin {
    @Unique
    private static final int TABS_PER_PAGE = 10;

    @Inject(method={"collect"}, at={@At(value="HEAD")}, cancellable=true)
    private static void collect(CallbackInfo ci) {
        List<RegistryKey> vanillaGroups = List.of(ItemGroups.BUILDING_BLOCKS, ItemGroups.COLORED_BLOCKS, ItemGroups.NATURAL, ItemGroups.FUNCTIONAL, ItemGroups.REDSTONE, ItemGroups.HOTBAR, ItemGroups.SEARCH, ItemGroups.TOOLS, ItemGroups.COMBAT, ItemGroups.FOOD_AND_DRINK, ItemGroups.INGREDIENTS, ItemGroups.SPAWN_EGGS, ItemGroups.OPERATOR, ItemGroups.INVENTORY);
        int count = 0;
        List<RegistryKey> sortedItemGroups = Registries.ITEM_GROUP.getKeys().stream().sorted(Comparator.comparing(RegistryKey::getValue)).toList();
        for (RegistryKey registryKey : sortedItemGroups) {
            ItemGroup itemGroup = (ItemGroup)Registries.ITEM_GROUP.getOrThrow(registryKey);
            FabricItemGroup fabricItemGroup = (FabricItemGroup)itemGroup;
            if (vanillaGroups.contains(registryKey)) {
                fabricItemGroup.setPage(0);
                continue;
            }
            ItemGroupAccessor itemGroupAccessor = (ItemGroupAccessor)itemGroup;
            fabricItemGroup.setPage(count / 10 + 1);
            int pageIndex = count % 10;
            ItemGroup.Row row = pageIndex < 5 ? ItemGroup.Row.TOP : ItemGroup.Row.BOTTOM;
            itemGroupAccessor.setRow(row);
            itemGroupAccessor.setColumn(row == ItemGroup.Row.TOP ? pageIndex % 10 : (pageIndex - 5) % 10);
            ++count;
        }
        record ItemGroupPosition(ItemGroup.Row row, int column, int page) {
        }
        HashMap<ItemGroupPosition, String> map = new HashMap<ItemGroupPosition, String>();
        for (RegistryKey registryKey : Registries.ITEM_GROUP.getKeys()) {
            ItemGroup itemGroup = (ItemGroup)Registries.ITEM_GROUP.getOrThrow(registryKey);
            FabricItemGroup fabricItemGroup = (FabricItemGroup)itemGroup;
            String displayName = itemGroup.getDisplayName().getString();
            ItemGroupPosition position = new ItemGroupPosition(itemGroup.getRow(), itemGroup.getColumn(), fabricItemGroup.getPage());
            String existingName = map.put(position, displayName);
            if (existingName == null) continue;
            throw new IllegalArgumentException("Duplicate position: (%s) for item groups %s vs %s".formatted(position, displayName, existingName));
        }
        ci.cancel();
    }
}

