/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.fabricmc.fabric.api.recipe.v1.ingredient.FabricIngredient;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.recipe.Ingredient;
import net.minecraft.util.Identifier;
import net.minecraft.util.JsonHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Ingredient.class})
public class IngredientMixin
implements FabricIngredient {
    @Inject(at={@At(value="INVOKE", target="net/minecraft/recipe/Ingredient.entryFromJson(Lcom/google/gson/JsonObject;)Lnet/minecraft/recipe/Ingredient$Entry;", ordinal=0)}, method={"fromJson(Lcom/google/gson/JsonElement;Z)Lnet/minecraft/recipe/Ingredient;"}, cancellable=true)
    private static void injectFromJson(JsonElement json, boolean requireNotEmpty, CallbackInfoReturnable<Ingredient> cir) {
        JsonObject obj = json.getAsJsonObject();
        if (obj.has("fabric:type")) {
            Identifier id = new Identifier(JsonHelper.getString((JsonObject)obj, (String)"fabric:type"));
            CustomIngredientSerializer<?> serializer = CustomIngredientSerializer.get(id);
            if (serializer != null) {
                cir.setReturnValue((Object)serializer.read(obj).toVanilla());
            } else {
                throw new IllegalArgumentException("Unknown custom ingredient type: " + String.valueOf(id));
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"entryFromJson"})
    private static void injectEntryFromJson(JsonObject obj, CallbackInfoReturnable<?> cir) {
        if (obj.has("fabric:type")) {
            throw new IllegalArgumentException("Custom ingredient cannot be used inside an array ingredient. You can replace the array by a fabric:any ingredient.");
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"fromPacket"}, cancellable=true)
    private static void injectFromPacket(PacketByteBuf buf, CallbackInfoReturnable<Ingredient> cir) {
        int index = buf.readerIndex();
        if (buf.readVarInt() == -1) {
            Identifier type = buf.readIdentifier();
            CustomIngredientSerializer<?> serializer = CustomIngredientSerializer.get(type);
            if (serializer == null) {
                throw new IllegalArgumentException("Cannot deserialize custom ingredient of unknown type " + String.valueOf(type));
            }
            cir.setReturnValue((Object)serializer.read(buf).toVanilla());
        } else {
            buf.readerIndex(index);
        }
    }
}

