/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.client.render.fluid.v1;

import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.minecraft.client.texture.Sprite;
import net.minecraft.client.texture.SpriteAtlasTexture;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.Identifier;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.BlockRenderView;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class SimpleFluidRenderHandler
implements FluidRenderHandler {
    public static final Identifier WATER_STILL = new Identifier("block/water_still");
    public static final Identifier WATER_FLOWING = new Identifier("block/water_flow");
    public static final Identifier WATER_OVERLAY = new Identifier("block/water_overlay");
    public static final Identifier LAVA_STILL = new Identifier("block/lava_still");
    public static final Identifier LAVA_FLOWING = new Identifier("block/lava_flow");
    protected final Identifier stillTexture;
    protected final Identifier flowingTexture;
    protected final Identifier overlayTexture;
    protected final Sprite[] sprites;
    protected final int tint;

    public SimpleFluidRenderHandler(Identifier stillTexture, Identifier flowingTexture, @Nullable Identifier overlayTexture, int tint) {
        this.stillTexture = Objects.requireNonNull(stillTexture, "stillTexture");
        this.flowingTexture = Objects.requireNonNull(flowingTexture, "flowingTexture");
        this.overlayTexture = overlayTexture;
        this.sprites = new Sprite[overlayTexture == null ? 2 : 3];
        this.tint = tint;
    }

    public SimpleFluidRenderHandler(Identifier stillTexture, Identifier flowingTexture, Identifier overlayTexture) {
        this(stillTexture, flowingTexture, overlayTexture, -1);
    }

    public SimpleFluidRenderHandler(Identifier stillTexture, Identifier flowingTexture, int tint) {
        this(stillTexture, flowingTexture, null, tint);
    }

    public SimpleFluidRenderHandler(Identifier stillTexture, Identifier flowingTexture) {
        this(stillTexture, flowingTexture, null, -1);
    }

    public static SimpleFluidRenderHandler coloredWater(int tint) {
        return new SimpleFluidRenderHandler(WATER_STILL, WATER_FLOWING, WATER_OVERLAY, tint);
    }

    @Override
    public Sprite[] getFluidSprites(@Nullable BlockRenderView view, @Nullable BlockPos pos, FluidState state) {
        return this.sprites;
    }

    @Override
    public void reloadTextures(SpriteAtlasTexture textureAtlas) {
        this.sprites[0] = textureAtlas.getSprite(this.stillTexture);
        this.sprites[1] = textureAtlas.getSprite(this.flowingTexture);
        if (this.overlayTexture != null) {
            this.sprites[2] = textureAtlas.getSprite(this.overlayTexture);
        }
    }

    @Override
    public int getFluidColor(@Nullable BlockRenderView view, @Nullable BlockPos pos, FluidState state) {
        return this.tint;
    }
}

