/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.networking;

import net.fabricmc.fabric.impl.networking.DisconnectPacketSource;
import net.fabricmc.fabric.impl.networking.NetworkHandlerExtensions;
import net.fabricmc.fabric.impl.networking.server.ServerPlayNetworkAddon;
import net.minecraft.network.ClientConnection;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.c2s.play.CustomPayloadC2SPacket;
import net.minecraft.network.packet.s2c.play.DisconnectS2CPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerPlayNetworkHandler;
import net.minecraft.text.Text;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayNetworkHandler.class}, priority=999)
abstract class ServerPlayNetworkHandlerMixin
implements NetworkHandlerExtensions,
DisconnectPacketSource {
    @Shadow
    @Final
    private MinecraftServer field_14148;
    @Shadow
    @Final
    public ClientConnection field_14127;
    @Unique
    private ServerPlayNetworkAddon addon;

    ServerPlayNetworkHandlerMixin() {
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void initAddon(CallbackInfo ci) {
        this.addon = new ServerPlayNetworkAddon((ServerPlayNetworkHandler)this, this.field_14148);
        this.addon.lateInit();
    }

    @Inject(method={"onCustomPayload"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleCustomPayloadReceivedAsync(CustomPayloadC2SPacket packet, CallbackInfo ci) {
        if (this.addon.handle(packet)) {
            ci.cancel();
        }
    }

    @Inject(method={"onDisconnected"}, at={@At(value="HEAD")})
    private void handleDisconnection(Text reason, CallbackInfo ci) {
        this.addon.handleDisconnect();
    }

    public ServerPlayNetworkAddon getAddon() {
        return this.addon;
    }

    @Override
    public Packet<?> createDisconnectPacket(Text message) {
        return new DisconnectS2CPacket(message);
    }
}

