/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.networking;

import net.fabricmc.fabric.impl.networking.DisconnectPacketSource;
import net.fabricmc.fabric.impl.networking.NetworkHandlerExtensions;
import net.fabricmc.fabric.impl.networking.PacketCallbackListener;
import net.fabricmc.fabric.impl.networking.server.ServerLoginNetworkAddon;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.c2s.login.LoginQueryResponseC2SPacket;
import net.minecraft.network.packet.s2c.login.LoginDisconnectS2CPacket;
import net.minecraft.network.packet.s2c.login.LoginQueryRequestS2CPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerLoginNetworkHandler;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.text.Text;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLoginNetworkHandler.class})
abstract class ServerLoginNetworkHandlerMixin
implements NetworkHandlerExtensions,
DisconnectPacketSource,
PacketCallbackListener {
    @Shadow
    @Final
    private MinecraftServer field_14162;
    @Unique
    private ServerLoginNetworkAddon addon;

    ServerLoginNetworkHandlerMixin() {
    }

    @Shadow
    public abstract void method_14384();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void initAddon(CallbackInfo ci) {
        this.addon = new ServerLoginNetworkAddon((ServerLoginNetworkHandler)this);
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerLoginNetworkHandler;acceptPlayer()V"))
    private void handlePlayerJoin(ServerLoginNetworkHandler handler) {
        if (this.addon.queryTick()) {
            this.method_14384();
        }
    }

    @Inject(method={"onQueryResponse"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleCustomPayloadReceivedAsync(LoginQueryResponseC2SPacket packet, CallbackInfo ci) {
        if (this.addon.handle(packet)) {
            ci.cancel();
        }
    }

    @Redirect(method={"acceptPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getNetworkCompressionThreshold()I", ordinal=0))
    private int removeLateCompressionPacketSending(MinecraftServer server) {
        return -1;
    }

    @Inject(method={"onDisconnected"}, at={@At(value="HEAD")})
    private void handleDisconnection(Text reason, CallbackInfo ci) {
        this.addon.handleDisconnect();
    }

    @Inject(method={"addToServer"}, at={@At(value="HEAD")})
    private void handlePlayTransitionNormal(ServerPlayerEntity player, CallbackInfo ci) {
        this.addon.handlePlayTransition();
    }

    @Override
    public void sent(Packet<?> packet) {
        if (packet instanceof LoginQueryRequestS2CPacket) {
            this.addon.registerOutgoingPacket((LoginQueryRequestS2CPacket)packet);
        }
    }

    public ServerLoginNetworkAddon getAddon() {
        return this.addon;
    }

    @Override
    public Packet<?> createDisconnectPacket(Text message) {
        return new LoginDisconnectS2CPacket(message);
    }
}

