/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.networking.v1;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.impl.networking.server.ServerNetworkingImpl;
import net.fabricmc.fabric.mixin.networking.accessor.ServerLoginNetworkHandlerAccessor;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerLoginNetworkHandler;
import net.minecraft.util.Identifier;
import org.jetbrains.annotations.Nullable;

public final class ServerLoginNetworking {
    public static boolean registerGlobalReceiver(Identifier channelName, LoginQueryResponseHandler channelHandler) {
        return ServerNetworkingImpl.LOGIN.registerGlobalReceiver(channelName, channelHandler);
    }

    @Nullable
    public static LoginQueryResponseHandler unregisterGlobalReceiver(Identifier channelName) {
        return ServerNetworkingImpl.LOGIN.unregisterGlobalReceiver(channelName);
    }

    public static Set<Identifier> getGlobalReceivers() {
        return ServerNetworkingImpl.LOGIN.getChannels();
    }

    public static boolean registerReceiver(ServerLoginNetworkHandler networkHandler, Identifier channelName, LoginQueryResponseHandler responseHandler) {
        Objects.requireNonNull(networkHandler, "Network handler cannot be null");
        return ServerNetworkingImpl.getAddon(networkHandler).registerChannel(channelName, responseHandler);
    }

    @Nullable
    public static LoginQueryResponseHandler unregisterReceiver(ServerLoginNetworkHandler networkHandler, Identifier channelName) {
        Objects.requireNonNull(networkHandler, "Network handler cannot be null");
        return (LoginQueryResponseHandler)ServerNetworkingImpl.getAddon(networkHandler).unregisterChannel(channelName);
    }

    public static MinecraftServer getServer(ServerLoginNetworkHandler handler) {
        Objects.requireNonNull(handler, "Network handler cannot be null");
        return ((ServerLoginNetworkHandlerAccessor)handler).getServer();
    }

    private ServerLoginNetworking() {
    }

    @FunctionalInterface
    public static interface LoginQueryResponseHandler {
        public void receive(MinecraftServer var1, ServerLoginNetworkHandler var2, boolean var3, PacketByteBuf var4, LoginSynchronizer var5, PacketSender var6);
    }

    @FunctionalInterface
    public static interface LoginSynchronizer {
        public void waitFor(Future<?> var1);
    }
}

